/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.policy;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.deployment.model.internal.policy.PolicyTemplateClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ParentFirstLookupStrategy;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class PolicyTemplateClassLoaderFactoryTestCase
extends AbstractMuleTestCase {
    private static final String POLICY_ID = "policy/policyId";
    private final ClassLoaderLookupPolicy lookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);
    @Rule
    public TemporaryFolder policyFolder = new TemporaryFolder();
    private PolicyTemplateClassLoaderFactory factory = new PolicyTemplateClassLoaderFactory();
    private PolicyTemplateDescriptor descriptor;
    private ArtifactClassLoader parentClassLoader;

    @Before
    public void setUp() throws Exception {
        this.descriptor = new PolicyTemplateDescriptor("testPolicy");
        this.descriptor.setRootFolder(this.policyFolder.getRoot());
        this.parentClassLoader = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
        Mockito.when((Object)this.parentClassLoader.getClassLoader()).thenReturn((Object)((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.lookupPolicy.getClassLookupStrategy(org.mockito.Matchers.anyString())).thenReturn((Object)ParentFirstLookupStrategy.PARENT_FIRST);
        Mockito.when((Object)this.parentClassLoader.getClassLoaderLookupPolicy()).thenReturn((Object)this.lookupPolicy);
    }

    @Test
    public void createsEmptyClassLoader() throws Exception {
        ArtifactClassLoader artifactClassLoader = this.factory.create(POLICY_ID, this.parentClassLoader, this.descriptor, Collections.emptyList());
        MuleArtifactClassLoader classLoader = (MuleArtifactClassLoader)artifactClassLoader.getClassLoader();
        Assert.assertThat((Object)classLoader.getURLs(), (Matcher)IsEqual.equalTo((Object)new URL[0]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void validatesPolicyFolder() throws Exception {
        File fakePolicyFolder = new File("./fake/folder/for/test");
        this.descriptor.setRootFolder(fakePolicyFolder);
        this.factory.create(POLICY_ID, null, this.descriptor, Collections.emptyList());
    }

    @Test
    public void usesClassLoaderLookupPolicy() throws Exception {
        ArtifactClassLoader artifactClassLoader = this.factory.create(POLICY_ID, this.parentClassLoader, this.descriptor, Collections.emptyList());
        MuleArtifactClassLoader classLoader = (MuleArtifactClassLoader)artifactClassLoader.getClassLoader();
        String className = "com.dummy.Foo";
        try {
            classLoader.loadClass("com.dummy.Foo");
            TestCase.fail((String)"Able to load an un-existent class");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ((ClassLoaderLookupPolicy)Mockito.verify((Object)this.lookupPolicy)).getClassLookupStrategy("com.dummy.Foo");
    }

    @Test
    public void createsClassLoaderWithPlugins() throws Exception {
        ArtifactClassLoader pluginClassLoader1 = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
        ArtifactClassLoader pluginClassLoader2 = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
        ArrayList<ArtifactClassLoader> artifactPluginClassLoaders = new ArrayList<ArtifactClassLoader>();
        artifactPluginClassLoaders.add(pluginClassLoader1);
        artifactPluginClassLoaders.add(pluginClassLoader2);
        ArtifactClassLoader artifactClassLoader = this.factory.create(POLICY_ID, this.parentClassLoader, this.descriptor, artifactPluginClassLoaders);
        MuleDeployableArtifactClassLoader classLoader = (MuleDeployableArtifactClassLoader)artifactClassLoader.getClassLoader();
        Assert.assertThat((Object)classLoader.getArtifactPluginClassLoaders(), (Matcher)Matchers.contains((Object[])new ArtifactClassLoader[]{pluginClassLoader1, pluginClassLoader2}));
    }
}

