/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerOnlyLookupStrategy;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DelegateOnlyLookupStrategy;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultRegionPluginClassLoadersFactoryTestCase
extends AbstractMuleTestCase {
    private static final String REGION_ID = "regionId";
    private static final String PRIVILEGED_PACKAGE = "org.foo.privileged";
    private static final String GROUP_ID = "org.mule.test";
    private static final String PLUGIN_ID2 = "plugin2";
    private static final String PLUGIN_ARTIFACT_ID2 = "org.mule.test:plugin2";
    private static final String PLUGIN_ID1 = "plugin1";
    private static final String PLUGIN_ARTIFACT_ID1 = "org.mule.test:plugin1";
    private static final BundleDescriptor PLUGIN1_BUNDLE_DESCRIPTOR = new BundleDescriptor.Builder().setGroupId("org.mule.test").setArtifactId("plugin1").setVersion("1.0").setClassifier("mule-plugin").build();
    private static final BundleDescriptor PLUGIN2_BUNDLE_DESCRIPTOR = new BundleDescriptor.Builder().setGroupId("org.mule.test").setArtifactId("plugin2").setVersion("1.0").setClassifier("mule-plugin").build();
    private final ArtifactClassLoaderFactory pluginClassLoaderFactory = (ArtifactClassLoaderFactory)Mockito.mock(ArtifactClassLoaderFactory.class);
    private final ModuleRepository moduleRepository = (ModuleRepository)Mockito.mock(ModuleRepository.class);
    private final DefaultRegionPluginClassLoadersFactory factory = new DefaultRegionPluginClassLoadersFactory(this.pluginClassLoaderFactory, this.moduleRepository);
    private final ClassLoaderLookupPolicy regionOwnerLookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);
    private final ArtifactClassLoader regionClassLoader = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
    private final ArtifactPluginDescriptor plugin1Descriptor = new ArtifactPluginDescriptor("plugin1");
    private final ArtifactPluginDescriptor plugin2Descriptor = new ArtifactPluginDescriptor("plugin2");
    private final ArtifactClassLoader pluginClassLoader1 = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
    private final ArtifactClassLoader pluginClassLoader2 = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
    private final ClassLoaderLookupPolicy pluginLookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.regionClassLoader.getArtifactId()).thenReturn((Object)REGION_ID);
        Mockito.when((Object)this.regionClassLoader.getClassLoader()).thenReturn((Object)((Object)((Object)this)).getClass().getClassLoader());
        String pluginId1 = DefaultRegionPluginClassLoadersFactory.getArtifactPluginId((String)REGION_ID, (String)PLUGIN_ID1);
        Mockito.when((Object)this.pluginClassLoaderFactory.create(pluginId1, (ArtifactDescriptor)this.plugin1Descriptor, ((Object)((Object)this)).getClass().getClassLoader(), this.pluginLookupPolicy)).thenReturn((Object)this.pluginClassLoader1);
        String pluginId2 = DefaultRegionPluginClassLoadersFactory.getArtifactPluginId((String)REGION_ID, (String)PLUGIN_ID2);
        Mockito.when((Object)this.pluginClassLoaderFactory.create(pluginId2, (ArtifactDescriptor)this.plugin2Descriptor, ((Object)((Object)this)).getClass().getClassLoader(), this.pluginLookupPolicy)).thenReturn((Object)this.pluginClassLoader2);
        this.plugin1Descriptor.setBundleDescriptor(PLUGIN1_BUNDLE_DESCRIPTOR);
        this.plugin2Descriptor.setBundleDescriptor(PLUGIN2_BUNDLE_DESCRIPTOR);
        Mockito.when((Object)this.pluginClassLoader1.getClassLoader()).thenReturn((Object)((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.pluginClassLoader1.getArtifactDescriptor()).thenReturn((Object)this.plugin1Descriptor);
        Mockito.when((Object)this.pluginClassLoader2.getClassLoader()).thenReturn((Object)((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.pluginClassLoader2.getArtifactDescriptor()).thenReturn((Object)this.plugin2Descriptor);
    }

    @Test
    public void createsNoPlugins() throws Exception {
        List pluginClassLoaders = this.factory.createPluginClassLoaders(this.regionClassLoader, Collections.emptyList(), this.regionOwnerLookupPolicy);
        MatcherAssert.assertThat((Object)pluginClassLoaders, (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void createsSinglePlugin() throws Exception {
        List<ArtifactPluginDescriptor> artifactPluginDescriptors = Collections.singletonList(this.plugin1Descriptor);
        Mockito.when((Object)this.regionOwnerLookupPolicy.extend((Map)org.mockito.Matchers.argThat((Matcher)Matchers.any(Map.class)))).thenReturn((Object)this.pluginLookupPolicy);
        List pluginClassLoaders = this.factory.createPluginClassLoaders(this.regionClassLoader, artifactPluginDescriptors, this.regionOwnerLookupPolicy);
        MatcherAssert.assertThat((Object)pluginClassLoaders, (Matcher)Matchers.contains((Object[])new ArtifactClassLoader[]{this.pluginClassLoader1}));
    }

    @Test
    public void createsIndependentPlugins() throws Exception {
        ArrayList<ArtifactPluginDescriptor> artifactPluginDescriptors = new ArrayList<ArtifactPluginDescriptor>();
        artifactPluginDescriptors.add(this.plugin1Descriptor);
        artifactPluginDescriptors.add(this.plugin2Descriptor);
        Mockito.when((Object)this.regionOwnerLookupPolicy.extend((Map)org.mockito.Matchers.argThat((Matcher)Matchers.any(Map.class)))).thenReturn((Object)this.pluginLookupPolicy);
        List pluginClassLoaders = this.factory.createPluginClassLoaders(this.regionClassLoader, artifactPluginDescriptors, this.regionOwnerLookupPolicy);
        MatcherAssert.assertThat((Object)pluginClassLoaders, (Matcher)Matchers.contains((Object[])new ArtifactClassLoader[]{this.pluginClassLoader1, this.pluginClassLoader2}));
    }

    @Test
    public void createsDependantPlugins() throws Exception {
        BundleDependency pluginDependency = new BundleDependency.Builder().setScope(BundleScope.COMPILE).setDescriptor(PLUGIN1_BUNDLE_DESCRIPTOR).build();
        this.plugin2Descriptor.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(pluginDependency)).build());
        ArrayList<ArtifactPluginDescriptor> artifactPluginDescriptors = new ArrayList<ArtifactPluginDescriptor>();
        artifactPluginDescriptors.add(this.plugin1Descriptor);
        artifactPluginDescriptors.add(this.plugin2Descriptor);
        Mockito.when((Object)this.regionOwnerLookupPolicy.extend((Map)org.mockito.Matchers.argThat((Matcher)Matchers.any(Map.class)))).thenReturn((Object)this.pluginLookupPolicy);
        List pluginClassLoaders = this.factory.createPluginClassLoaders(this.regionClassLoader, artifactPluginDescriptors, this.regionOwnerLookupPolicy);
        MatcherAssert.assertThat((Object)pluginClassLoaders, (Matcher)Matchers.contains((Object[])new ArtifactClassLoader[]{this.pluginClassLoader1, this.pluginClassLoader2}));
    }

    @Test
    public void createsPluginWithPrivilegedContainerAccess() throws Exception {
        MuleModule privilegedModule = (MuleModule)Mockito.mock(MuleModule.class);
        Mockito.when((Object)privilegedModule.getPrivilegedArtifacts()).thenReturn(Collections.singleton(PLUGIN_ARTIFACT_ID1));
        Mockito.when((Object)privilegedModule.getPrivilegedExportedPackages()).thenReturn(Collections.singleton(PRIVILEGED_PACKAGE));
        Mockito.when((Object)this.moduleRepository.getModules()).thenReturn(Collections.singletonList(privilegedModule));
        List<ArtifactPluginDescriptor> artifactPluginDescriptors = Collections.singletonList(this.plugin1Descriptor);
        ArgumentCaptor mapArgumentCaptor = ArgumentCaptor.forClass(Map.class);
        Mockito.when((Object)this.regionOwnerLookupPolicy.extend((Map)mapArgumentCaptor.capture())).thenReturn((Object)this.pluginLookupPolicy);
        List pluginClassLoaders = this.factory.createPluginClassLoaders(this.regionClassLoader, artifactPluginDescriptors, this.regionOwnerLookupPolicy);
        MatcherAssert.assertThat((Object)pluginClassLoaders, (Matcher)Matchers.contains((Object[])new ArtifactClassLoader[]{this.pluginClassLoader1}));
        Map value = (Map)mapArgumentCaptor.getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)PRIVILEGED_PACKAGE), (Matcher)Matchers.instanceOf(ContainerOnlyLookupStrategy.class)));
    }

    @Test
    public void createsPluginWithPrivilegedPluginAccess() throws Exception {
        ClassLoaderModel plugin1ClassLoaderModel = new ClassLoaderModel.ClassLoaderModelBuilder().exportingPrivilegedPackages(Collections.singleton(PRIVILEGED_PACKAGE), Collections.singleton(PLUGIN_ARTIFACT_ID2)).build();
        this.plugin1Descriptor.setClassLoaderModel(plugin1ClassLoaderModel);
        BundleDependency pluginDependency = new BundleDependency.Builder().setScope(BundleScope.COMPILE).setDescriptor(PLUGIN1_BUNDLE_DESCRIPTOR).build();
        this.plugin2Descriptor.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(pluginDependency)).build());
        ArrayList<ArtifactPluginDescriptor> artifactPluginDescriptors = new ArrayList<ArtifactPluginDescriptor>();
        artifactPluginDescriptors.add(this.plugin1Descriptor);
        artifactPluginDescriptors.add(this.plugin2Descriptor);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Map.class);
        Mockito.when((Object)this.regionOwnerLookupPolicy.extend((Map)argumentCaptor.capture())).thenReturn((Object)this.pluginLookupPolicy);
        List pluginClassLoaders = this.factory.createPluginClassLoaders(this.regionClassLoader, artifactPluginDescriptors, this.regionOwnerLookupPolicy);
        MatcherAssert.assertThat((Object)pluginClassLoaders, (Matcher)Matchers.contains((Object[])new ArtifactClassLoader[]{this.pluginClassLoader1, this.pluginClassLoader2}));
        MatcherAssert.assertThat((Object)((Map)argumentCaptor.getAllValues().get(0)), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)PRIVILEGED_PACKAGE), (Matcher)Matchers.instanceOf(DelegateOnlyLookupStrategy.class))));
        MatcherAssert.assertThat((Object)((Map)argumentCaptor.getAllValues().get(1)), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)PRIVILEGED_PACKAGE), (Matcher)Matchers.instanceOf(DelegateOnlyLookupStrategy.class)));
    }
}

