/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.plugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.beans.HasPropertyWithValue;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.plugin.BundlePluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.plugin.DuplicateExportedPackageException;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.plugin.PluginResolutionError;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class BundlePluginDependenciesResolverTestCase
extends AbstractMuleTestCase {
    private static final String FOO_PLUGIN = "foo";
    private static final String BAZ_PLUGIN = "baz";
    private static final String BAR_PLUGIN = "bar";
    private static final String ECHO_PLUGIN = "echo";
    public static final String DEPENDENCY_PROVIDER_ERROR_MESSAGE = "Bundle URL should have been resolved for %s.";
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static BundleDescriptor FOO_BUNDLE_DESCRIPTOR;
    private static BundleDescriptor BAZ_BUNDLE_DESCRIPTOR;
    private static BundleDescriptor LATEST_BAZ_BUNDLE_DESCRIPTOR;
    private static BundleDescriptor BAR_BUNDLE_DESCRIPTOR;
    private static BundleDescriptor ECHO_BUNDLE_DESCRIPTOR;
    private static BundleDescriptor LATEST_ECHO_BUNDLE_DESCRIPTOR;
    private static BundleDependency FOO_PLUGIN_DESCRIPTOR;
    private static BundleDependency BAZ_PLUGIN_DESCRIPTOR;
    private static BundleDependency LATEST_BAZ_PLUGIN_DESCRIPTOR;
    private static BundleDependency BAR_PLUGIN_DESCRIPTOR;
    private static BundleDependency ECHO_PLUGIN_DESCRIPTOR;
    private static BundleDependency LATEST_ECHO_PLUGIN_DESCRIPTOR;
    private final ArtifactPluginDescriptor fooPlugin = BundlePluginDependenciesResolverTestCase.newArtifactPluginDescriptor("foo");
    private final ArtifactPluginDescriptor barPlugin = BundlePluginDependenciesResolverTestCase.newArtifactPluginDescriptor("bar");
    private final ArtifactPluginDescriptor bazPlugin = BundlePluginDependenciesResolverTestCase.newArtifactPluginDescriptor("baz");
    private final ArtifactPluginDescriptor latestBazPlugin = BundlePluginDependenciesResolverTestCase.newArtifactPluginDescriptor("baz");
    private final ArtifactPluginDescriptor echoPlugin = BundlePluginDependenciesResolverTestCase.newArtifactPluginDescriptor("echo");
    private final ArtifactPluginDescriptor latestEchoPlugin = BundlePluginDependenciesResolverTestCase.newArtifactPluginDescriptor("echo");
    private PluginDependenciesResolver dependenciesResolver;
    private ArtifactDescriptorFactory artifactDescriptorFactory;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @BeforeClass
    public static void before() {
        FOO_BUNDLE_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(FOO_PLUGIN, "1.0");
        BAZ_BUNDLE_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(BAZ_PLUGIN, "1.0");
        LATEST_BAZ_BUNDLE_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(BAZ_PLUGIN, "1.1");
        BAR_BUNDLE_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(BAR_PLUGIN, "1.0");
        ECHO_BUNDLE_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(ECHO_PLUGIN, "1.0");
        LATEST_ECHO_BUNDLE_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(ECHO_PLUGIN, "1.1");
        FOO_PLUGIN_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createBundleDependency(FOO_BUNDLE_DESCRIPTOR);
        BAZ_PLUGIN_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createBundleDependency(BAZ_BUNDLE_DESCRIPTOR, true);
        LATEST_BAZ_PLUGIN_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createBundleDependency(LATEST_BAZ_BUNDLE_DESCRIPTOR, true);
        BAR_PLUGIN_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createBundleDependency(BAR_BUNDLE_DESCRIPTOR);
        ECHO_PLUGIN_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createBundleDependency(ECHO_BUNDLE_DESCRIPTOR);
        LATEST_ECHO_PLUGIN_DESCRIPTOR = BundlePluginDependenciesResolverTestCase.createBundleDependency(LATEST_ECHO_BUNDLE_DESCRIPTOR, true);
    }

    private static BundleDependency createBundleDependency(BundleDescriptor bundleDescriptor) {
        return BundlePluginDependenciesResolverTestCase.createBundleDependency(bundleDescriptor, false);
    }

    private static BundleDependency createBundleDependency(BundleDescriptor bundleDescriptor, boolean createBundleUri) {
        try {
            BundleDependency.Builder builder = new BundleDependency.Builder();
            builder.setDescriptor(bundleDescriptor);
            builder.setScope(BundleScope.COMPILE);
            if (createBundleUri) {
                builder.setBundleUri(temporaryFolder.newFile(bundleDescriptor.getArtifactFileName()).toURI());
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static BundleDescriptor createTestBundleDescriptor(String artifactId, String version) {
        return new BundleDescriptor.Builder().setGroupId("test").setArtifactId(artifactId).setVersion(version).setType("jar").setClassifier("mule-plugin").build();
    }

    @Before
    public void setUp() throws Exception {
        this.fooPlugin.setBundleDescriptor(FOO_BUNDLE_DESCRIPTOR);
        this.bazPlugin.setBundleDescriptor(BAZ_BUNDLE_DESCRIPTOR);
        this.latestBazPlugin.setBundleDescriptor(LATEST_BAZ_BUNDLE_DESCRIPTOR);
        this.barPlugin.setBundleDescriptor(BAR_BUNDLE_DESCRIPTOR);
        this.echoPlugin.setBundleDescriptor(ECHO_BUNDLE_DESCRIPTOR);
        this.latestEchoPlugin.setBundleDescriptor(LATEST_ECHO_BUNDLE_DESCRIPTOR);
        this.artifactDescriptorFactory = (ArtifactDescriptorFactory)Mockito.mock(ArtifactDescriptorFactory.class);
        this.dependenciesResolver = new BundlePluginDependenciesResolver(this.artifactDescriptorFactory);
    }

    private static ArtifactPluginDescriptor newArtifactPluginDescriptor(String name) {
        return new ArtifactPluginDescriptor(name);
    }

    @Test
    public void resolvesIndependentPlugins() throws Exception {
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.barPlugin);
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.barPlugin, this.fooPlugin);
    }

    @Test
    public void resolvesPluginOrderedDependency() throws Exception {
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.barPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(FOO_PLUGIN_DESCRIPTOR)).build());
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.fooPlugin, this.barPlugin);
    }

    @Test
    public void resolvesPluginDisorderedDependency() throws Exception {
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.barPlugin, this.fooPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(FOO_PLUGIN_DESCRIPTOR)).build());
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.fooPlugin, this.barPlugin);
    }

    @Test
    public void resolvesPluginDependencyWithCompatibleMinorVersion() throws Exception {
        ArtifactPluginDescriptor updatedFooPlugin = new ArtifactPluginDescriptor(FOO_PLUGIN);
        updatedFooPlugin.setBundleDescriptor(BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(FOO_PLUGIN, "1.1"));
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(updatedFooPlugin, this.barPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BundlePluginDependenciesResolverTestCase.createBundleDependency(FOO_BUNDLE_DESCRIPTOR))).build());
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
        this.assertResolvedPlugins(resolvedPluginDescriptors, updatedFooPlugin, this.barPlugin);
    }

    @Test
    public void resolvesPluginDependencyWithSnapshotMinorVersion() throws Exception {
        ArtifactPluginDescriptor updatedFooPlugin = new ArtifactPluginDescriptor(FOO_PLUGIN);
        updatedFooPlugin.setBundleDescriptor(BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(FOO_PLUGIN, "1.1-SNAPSHOT"));
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(updatedFooPlugin, this.barPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BundlePluginDependenciesResolverTestCase.createBundleDependency(FOO_BUNDLE_DESCRIPTOR))).build());
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
        this.assertResolvedPlugins(resolvedPluginDescriptors, updatedFooPlugin, this.barPlugin);
    }

    @Test
    public void resolvesSnapshotPluginDependencyWithCompatibleMinorVersion() throws Exception {
        ArtifactPluginDescriptor updatedFooPlugin = new ArtifactPluginDescriptor(FOO_PLUGIN);
        updatedFooPlugin.setBundleDescriptor(BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(FOO_PLUGIN, "1.1"));
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(updatedFooPlugin, this.barPlugin);
        BundleDescriptor fooBundleDescriptor = BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(FOO_PLUGIN, "1.0-SNAPSHOT");
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BundlePluginDependenciesResolverTestCase.createBundleDependency(fooBundleDescriptor))).build());
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
        this.assertResolvedPlugins(resolvedPluginDescriptors, updatedFooPlugin, this.barPlugin);
    }

    @Test(expected=PluginResolutionError.class)
    public void doesNotResolvesPluginDependencyWithIncompatibleMajorVersion() throws Exception {
        ArtifactPluginDescriptor majorUpdatedFooPlugin = new ArtifactPluginDescriptor(FOO_PLUGIN);
        majorUpdatedFooPlugin.setBundleDescriptor(BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(FOO_PLUGIN, "2.0"));
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(majorUpdatedFooPlugin, this.barPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BundlePluginDependenciesResolverTestCase.createBundleDependency(FOO_BUNDLE_DESCRIPTOR))).build());
        this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
    }

    @Test(expected=PluginResolutionError.class)
    public void doesNotResolvesPluginDependencyWithIncompatibleMinorVersion() throws Exception {
        ArtifactPluginDescriptor majorUpdatedFooPlugin = new ArtifactPluginDescriptor(FOO_PLUGIN);
        majorUpdatedFooPlugin.setBundleDescriptor(BundlePluginDependenciesResolverTestCase.createTestBundleDescriptor(FOO_PLUGIN, "1.1"));
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.barPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BundlePluginDependenciesResolverTestCase.createBundleDependency(majorUpdatedFooPlugin.getBundleDescriptor()))).build());
        this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
    }

    @Test
    public void detectsUnresolvablePluginDependency() throws Exception {
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin);
        this.fooPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BAR_PLUGIN_DESCRIPTOR)).build());
        this.expectedException.expect(PluginResolutionError.class);
        this.expectedException.expectMessage(String.format(DEPENDENCY_PROVIDER_ERROR_MESSAGE, BAR_BUNDLE_DESCRIPTOR));
        this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
    }

    @Test
    public void resolvesTransitiveDependencies() throws Exception {
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.barPlugin, this.bazPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BAZ_PLUGIN_DESCRIPTOR)).build());
        this.bazPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(FOO_PLUGIN_DESCRIPTOR)).build());
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.fooPlugin, this.bazPlugin, this.barPlugin);
    }

    @Test
    public void resolvesMultipleDependencies() throws Exception {
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.bazPlugin, this.barPlugin, this.fooPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BAZ_PLUGIN_DESCRIPTOR)).build());
        this.bazPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(FOO_PLUGIN_DESCRIPTOR)).build());
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.fooPlugin, this.bazPlugin, this.barPlugin);
    }

    @Test
    public void resolvesPluginWithNewestVersionOnDependency() throws Exception {
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.barPlugin, this.bazPlugin, this.fooPlugin);
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(LATEST_BAZ_PLUGIN_DESCRIPTOR)).build());
        this.bazPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(FOO_PLUGIN_DESCRIPTOR)).build());
        this.latestBazPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(FOO_PLUGIN_DESCRIPTOR)).build());
        Mockito.when((Object)this.artifactDescriptorFactory.create((File)org.mockito.Matchers.argThat((Matcher)HasPropertyWithValue.hasProperty((String)"absolutePath", (Matcher)Matchers.endsWith((String)this.latestBazPlugin.getBundleDescriptor().getArtifactFileName()))), (Optional)org.mockito.Matchers.any(Optional.class))).thenReturn((Object)this.latestBazPlugin);
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.fooPlugin, this.bazPlugin, this.barPlugin);
    }

    @Test
    public void resolvesDependenciesTwoVersionWhenLatestComesFromTransitiveMinor() throws Exception {
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.latestEchoPlugin, this.bazPlugin);
        this.latestEchoPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(BAZ_PLUGIN_DESCRIPTOR)).build());
        this.fooPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(ECHO_PLUGIN_DESCRIPTOR)).build());
        this.echoPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(LATEST_BAZ_PLUGIN_DESCRIPTOR)).build());
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.bazPlugin, this.latestEchoPlugin, this.fooPlugin);
    }

    @Test
    public void sanitizesDependantPluginExportedPackages() throws Exception {
        this.fooPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(this.getFooExportedPackages()).build());
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(Collections.singleton(FOO_PLUGIN_DESCRIPTOR)).exportingPackages(this.getBarExportedPackages()).build());
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.barPlugin);
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.fooPlugin, this.barPlugin);
        this.assertPluginExportedPackages(this.fooPlugin, "org.foo", "org.foo.mule");
        this.assertPluginExportedPackages(this.barPlugin, "org.bar", "org.baz", "org.bar.mule");
    }

    @Test
    public void sanitizesTransitiveDependantPluginExportedPackages() throws Exception {
        this.fooPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(this.getFooExportedPackages()).build());
        this.bazPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(this.getBazExportedPackages()).dependingOn(Collections.singleton(FOO_PLUGIN_DESCRIPTOR)).build());
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(this.getBarExportedPackages()).dependingOn(Collections.singleton(BAZ_PLUGIN_DESCRIPTOR)).build());
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.barPlugin, this.bazPlugin);
        List resolvedPluginDescriptors = this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
        this.assertResolvedPlugins(resolvedPluginDescriptors, this.fooPlugin, this.bazPlugin, this.barPlugin);
        this.assertPluginExportedPackages(this.fooPlugin, "org.foo", "org.foo.mule");
        this.assertPluginExportedPackages(this.bazPlugin, "org.baz");
        this.assertPluginExportedPackages(this.barPlugin, "org.bar", "org.bar.mule");
    }

    @Test
    public void detectsDuplicateExportedPackagesOnIndependentPlugins() throws Exception {
        this.fooPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(this.getFooExportedPackages()).build());
        this.barPlugin.setClassLoaderModel(new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(this.getBarExportedPackages()).build());
        List<ArtifactPluginDescriptor> pluginDescriptors = this.createPluginDescriptors(this.fooPlugin, this.barPlugin);
        HashMap<String, List<String>> pluginsPerPackage = new HashMap<String, List<String>>();
        pluginsPerPackage.put("org.foo", Arrays.asList("bar, foo"));
        pluginsPerPackage.put("org.foo.mule", Arrays.asList("bar, foo"));
        String expectedErrorMessage = new DuplicateExportedPackageException(pluginsPerPackage).getMessage();
        this.expectedException.expect(DuplicateExportedPackageException.class);
        this.expectedException.expectMessage(expectedErrorMessage);
        this.dependenciesResolver.resolve(Collections.emptySet(), pluginDescriptors, true);
    }

    @Test
    public void providedPluginsHaveOldestVersionOfSamePluginInPolicy() {
        this.dependenciesResolver.resolve((Set)ImmutableSet.of((Object)this.bazPlugin), (List)ImmutableList.of((Object)this.latestBazPlugin), false);
    }

    @Test
    public void providedPluginsHaveOldestVersionOfSamePluginInDomain() {
        this.expectedException.expect(IllegalStateException.class);
        this.dependenciesResolver.resolve((Set)ImmutableSet.of((Object)this.bazPlugin), (List)ImmutableList.of((Object)this.latestBazPlugin), true);
    }

    @Test
    public void providedPluginsHaveOldestVersionOfSameHttpPluginInPolicy() {
        BundleDescriptor httpDescriptor1_0 = new BundleDescriptor.Builder().setGroupId("org.mule.connectors").setArtifactId("mule-http-connector").setVersion("1.0.0").build();
        BundleDescriptor httpDescriptor1_1 = new BundleDescriptor.Builder().setGroupId("org.mule.connectors").setArtifactId("mule-http-connector").setVersion("1.1.0").build();
        ArtifactPluginDescriptor httpPluginDescriptor1_0 = BundlePluginDependenciesResolverTestCase.newArtifactPluginDescriptor("HTTP");
        httpPluginDescriptor1_0.setBundleDescriptor(httpDescriptor1_0);
        ArtifactPluginDescriptor httpPluginDescriptor1_1 = BundlePluginDependenciesResolverTestCase.newArtifactPluginDescriptor("HTTP");
        httpPluginDescriptor1_1.setBundleDescriptor(httpDescriptor1_1);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Incompatible version of plugin 'HTTP' (org.mule.connectors:mule-http-connector) found. Artifact requires version '1.1.0' but context provides version '1.0.0'");
        this.dependenciesResolver.resolve((Set)ImmutableSet.of((Object)httpPluginDescriptor1_0), (List)ImmutableList.of((Object)httpPluginDescriptor1_1), false);
    }

    private Set<String> getBarExportedPackages() {
        HashSet<String> barExportedClassPackages = new HashSet<String>();
        barExportedClassPackages.add("org.bar");
        barExportedClassPackages.add("org.baz");
        barExportedClassPackages.add("org.foo");
        barExportedClassPackages.add("org.foo.mule");
        barExportedClassPackages.add("org.bar.mule");
        return barExportedClassPackages;
    }

    private Set<String> getFooExportedPackages() {
        HashSet<String> fooExportedClassPackages = new HashSet<String>();
        fooExportedClassPackages.add("org.foo");
        fooExportedClassPackages.add("org.foo.mule");
        return fooExportedClassPackages;
    }

    private Set<String> getBazExportedPackages() {
        HashSet<String> bazExportedClassPackages = new HashSet<String>();
        bazExportedClassPackages.add("org.baz");
        return bazExportedClassPackages;
    }

    private void assertResolvedPlugins(List<ArtifactPluginDescriptor> resolvedPluginDescriptors, ArtifactPluginDescriptor ... expectedPluginDescriptors) {
        MatcherAssert.assertThat((Object)resolvedPluginDescriptors.size(), (Matcher)Matchers.equalTo((Object)expectedPluginDescriptors.length));
        MatcherAssert.assertThat(resolvedPluginDescriptors, (Matcher)Matchers.contains((Object[])expectedPluginDescriptors));
    }

    private void assertPluginExportedPackages(ArtifactPluginDescriptor pluginDescriptor, String ... exportedPackages) {
        MatcherAssert.assertThat((Object)pluginDescriptor.getClassLoaderModel().getExportedPackages().size(), (Matcher)Matchers.equalTo((Object)exportedPackages.length));
        MatcherAssert.assertThat((Object)pluginDescriptor.getClassLoaderModel().getExportedPackages(), (Matcher)Matchers.containsInAnyOrder((Object[])exportedPackages));
    }

    private List<ArtifactPluginDescriptor> createPluginDescriptors(ArtifactPluginDescriptor ... descriptors) {
        ArrayList<ArtifactPluginDescriptor> result = new ArrayList<ArtifactPluginDescriptor>();
        for (ArtifactPluginDescriptor descriptor : descriptors) {
            result.add(descriptor);
        }
        return result;
    }
}

