/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.domain.test;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;
import org.junitpioneer.jupiter.ClearSystemProperty;
import org.mule.runtime.container.internal.MuleClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.tck.junit4.AbstractMuleTestCase;

@ClearSystemProperty(key="mule.home")
public abstract class AbstractDomainTestCase
extends AbstractMuleTestCase {
    @TempDir
    public static File temporaryFolder;
    protected File muleHomeFolder;
    protected final ArtifactClassLoader containerClassLoader = new MuleArtifactClassLoader("mule", new ArtifactDescriptor("mule"), new URL[0], ((Object)((Object)this)).getClass().getClassLoader(), (ClassLoaderLookupPolicy)new MuleClassLoaderLookupPolicy(Collections.emptyMap(), Collections.emptySet()));

    @BeforeEach
    public void setMuleHome() throws IOException {
        System.setProperty("mule.home", temporaryFolder.getCanonicalPath());
        this.muleHomeFolder = temporaryFolder;
    }

    protected File createDomainDir(String domainFolder, String domain) {
        File file = new File(this.muleHomeFolder, domainFolder + File.separator + domain);
        MatcherAssert.assertThat((Object)file.mkdirs(), (Matcher)Is.is((Object)true));
        return file;
    }
}

