/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.deployment.model.internal.domain.test;

import static org.mule.runtime.core.api.config.MuleProperties.MULE_HOME_DIRECTORY_PROPERTY;

import static java.util.Collections.emptyMap;
import static java.util.Collections.emptySet;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;

import org.mule.runtime.container.internal.MuleClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.tck.junit4.AbstractMuleTestCase;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;
import org.junitpioneer.jupiter.ClearSystemProperty;

@ClearSystemProperty(key = MULE_HOME_DIRECTORY_PROPERTY)
public abstract class AbstractDomainTestCase extends AbstractMuleTestCase {

  @TempDir
  public static File temporaryFolder;

  protected File muleHomeFolder;
  protected final ArtifactClassLoader containerClassLoader =
      new MuleArtifactClassLoader("mule", new ArtifactDescriptor("mule"), new URL[0],
                                  getClass().getClassLoader(),
                                  new MuleClassLoaderLookupPolicy(emptyMap(), emptySet()));

  @BeforeEach
  public void setMuleHome() throws IOException {
    System.setProperty(MULE_HOME_DIRECTORY_PROPERTY, temporaryFolder.getCanonicalPath());
    muleHomeFolder = temporaryFolder;
  }

  protected File createDomainDir(String domainFolder, String domain) {
    final File file = new File(muleHomeFolder, domainFolder + File.separator + domain);
    assertThat(file.mkdirs(), is(true));
    return file;
  }
}
