/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.deployment.model.api.artifact;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.core.api.config.ConfigurationException;

import java.util.ServiceLoader;

/**
 * Implementation of this interface are responsible of processing the configuration files of a Mule artifact and create an
 * {@link ArtifactContext}.
 *
 * @since 4.0
 */
@NoImplement
public interface ArtifactConfigurationProcessor {

  /**
   * Discovers an override of the default {@link ArtifactConfigurationProcessor} using SPI. One and only one must be provided by a
   * module in the container.
   *
   * @return an {@link ArtifactConfigurationProcessor} discovered using SPI.
   */
  static ArtifactConfigurationProcessor discover() {
    return ServiceLoader.load(ArtifactConfigurationProcessor.class,
                              ArtifactConfigurationProcessor.class.getClassLoader())
        .findFirst()
        .orElse(null);
  }

  /**
   * Creates an {@link ArtifactContext} for an artifact based on the configuration files of the artifact.
   *
   * @param artifactContextConfiguration the configuration of the artifact.
   * @return an {@link ArtifactContext}
   * @throws ConfigurationException if there was a problem processing the configuration of the artifact.
   */
  ArtifactContext createArtifactContext(ArtifactContextConfiguration artifactContextConfiguration)
      throws ConfigurationException;

}
