/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.domain;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.deployment.model.internal.domain.MuleSharedDomainClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MuleSharedDomainClassLoaderTestCase
extends AbstractMuleTestCase {
    public static final String RESOURCE_FILE_NAME = "file.properties";
    @Rule
    public SystemPropertyTemporaryFolder temporaryFolder = new SystemPropertyTemporaryFolder("mule.home");
    private final ClassLoaderLookupPolicy lookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);

    @Test
    public void findResourcesInProvidedUrls() throws Exception {
        this.createDomainFolder("default");
        File resourceFile = this.createDomainResource("default", RESOURCE_FILE_NAME);
        List<URL> urls = Collections.singletonList(resourceFile.toURI().toURL());
        MuleSharedDomainClassLoader classLoader = new MuleSharedDomainClassLoader(new ArtifactDescriptor("default"), ((Object)((Object)this)).getClass().getClassLoader(), this.lookupPolicy, urls, Collections.emptyList());
        Assert.assertThat((Object)classLoader.findResource(RESOURCE_FILE_NAME), (Matcher)IsNull.notNullValue());
    }

    private File createDomainResource(String domainName, String resourceFile) throws Exception {
        File file = new File(MuleFoldersUtil.getDomainFolder((String)domainName), resourceFile);
        Assert.assertThat((Object)FileUtils.createFile((String)file.getAbsolutePath()).exists(), (Matcher)Is.is((Object)true));
        return file;
    }

    private void createDomainFolder(String domainName) {
        Assert.assertThat((Object)MuleFoldersUtil.getDomainFolder((String)domainName).mkdirs(), (Matcher)Is.is((Object)true));
    }
}

