/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.nativelib;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.deployment.model.internal.nativelib.ArtifactCopyNativeLibraryFinder;
import org.mule.runtime.deployment.model.internal.nativelib.MacOsMatcher;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ArtifactCopyNativeLibraryFinderTestCase
extends AbstractMuleTestCase {
    public static final String TEST_LIB_NAME = "test";
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public TemporaryFolder libFolder = new TemporaryFolder();

    @Test
    public void createsTempFolder() throws Exception {
        this.tempFolder.getRoot().delete();
        new ArtifactCopyNativeLibraryFinder(this.tempFolder.getRoot(), new URL[0]);
        MatcherAssert.assertThat((Object)this.tempFolder.getRoot().exists(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void cleansTempFolder() throws Exception {
        File nativeLibraryTempFolder = new File(this.tempFolder.getRoot(), "native");
        MatcherAssert.assertThat((Object)nativeLibraryTempFolder.mkdirs(), (Matcher)Matchers.is((Object)true));
        File libraryFile = this.createNativeLibraryFile(nativeLibraryTempFolder, "tempfile.jar");
        new ArtifactCopyNativeLibraryFinder(this.tempFolder.getRoot(), new URL[]{libraryFile.toURL()});
        MatcherAssert.assertThat((Object)libraryFile.exists(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void returnsNullWhenLibraryNotFound() throws Exception {
        ArtifactCopyNativeLibraryFinder nativeLibraryFinder = new ArtifactCopyNativeLibraryFinder(this.tempFolder.getRoot(), new URL[0]);
        String testLibPath = nativeLibraryFinder.findLibrary(TEST_LIB_NAME, null);
        MatcherAssert.assertThat((Object)testLibPath, (Matcher)Matchers.nullValue());
    }

    @Test
    public void findsLocalLibrary() throws Exception {
        File nativeLibrary = this.createDefaultNativeLibraryFile(TEST_LIB_NAME);
        ArtifactCopyNativeLibraryFinder nativeLibraryFinder = new ArtifactCopyNativeLibraryFinder(this.tempFolder.getRoot(), new URL[]{nativeLibrary.toURL()});
        String testLibPath = nativeLibraryFinder.findLibrary(TEST_LIB_NAME, null);
        MatcherAssert.assertThat((Object)testLibPath, (Matcher)Matchers.startsWith((String)this.tempFolder.getRoot().getAbsolutePath()));
        MatcherAssert.assertThat((Object)testLibPath, (Matcher)Matchers.containsString((String)TEST_LIB_NAME));
    }

    @Test
    public void findsLocalLibraryIfPathEncoded() throws Exception {
        File encodedPathFile = new File(this.tempFolder.getRoot(), "path with space");
        encodedPathFile.mkdir();
        File nativeLibrary = this.createDefaultNativeLibraryFile(encodedPathFile, TEST_LIB_NAME);
        ArtifactCopyNativeLibraryFinder nativeLibraryFinder = new ArtifactCopyNativeLibraryFinder(this.tempFolder.getRoot(), new URL[]{nativeLibrary.toURI().toURL()});
        String testLibPath = nativeLibraryFinder.findLibrary(TEST_LIB_NAME, null);
        MatcherAssert.assertThat((Object)testLibPath, (Matcher)Matchers.startsWith((String)this.tempFolder.getRoot().getAbsolutePath()));
        MatcherAssert.assertThat((Object)testLibPath, (Matcher)Matchers.containsString((String)TEST_LIB_NAME));
    }

    @Test
    public void findsJnilibInMac() throws Exception {
        Assume.assumeThat((Object)((Object)this), (Matcher)new MacOsMatcher());
        String libraryFileName = this.getJniLibFileName();
        File nativeLibrary = this.createNativeLibraryFile(this.libFolder.getRoot(), libraryFileName);
        ArtifactCopyNativeLibraryFinder nativeLibraryFinder = new ArtifactCopyNativeLibraryFinder(this.tempFolder.getRoot(), new URL[]{nativeLibrary.toURL()});
        String testLibPath = nativeLibraryFinder.findLibrary(TEST_LIB_NAME, null);
        MatcherAssert.assertThat((Object)testLibPath, (Matcher)Matchers.startsWith((String)this.tempFolder.getRoot().getAbsolutePath()));
        MatcherAssert.assertThat((Object)testLibPath, (Matcher)Matchers.containsString((String)TEST_LIB_NAME));
    }

    private File createDefaultNativeLibraryFile(File folder, String libName) throws IOException {
        return this.createNativeLibraryFile(folder, System.mapLibraryName(libName));
    }

    private File createDefaultNativeLibraryFile(String libName) throws IOException {
        return this.createDefaultNativeLibraryFile(this.libFolder.getRoot(), libName);
    }

    private File createNativeLibraryFile(File folder, String libFileName) throws IOException {
        File libraryFile = new File(folder, libFileName);
        FileUtils.write((File)libraryFile, (CharSequence)"SOME.NATIVE.CODE");
        return libraryFile;
    }

    private String getJniLibFileName() {
        String libraryFileName = System.mapLibraryName(TEST_LIB_NAME);
        int index = libraryFileName.lastIndexOf(".");
        libraryFileName = libraryFileName.substring(0, index) + ".jnilib";
        return libraryFileName;
    }
}

