/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.domain;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.internal.domain.AbstractDomainTestCase;
import org.mule.runtime.deployment.model.internal.domain.DomainClassLoaderFactory;
import org.mule.runtime.deployment.model.internal.domain.MuleSharedDomainClassLoader;
import org.mule.runtime.deployment.model.internal.nativelib.DefaultNativeLibraryFinderFactory;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;

public class DomainClassLoaderFactoryTestCase
extends AbstractDomainTestCase {
    @Rule
    public TemporaryFolder artifactLocation = new TemporaryFolder();

    @After
    public void tearDown() {
        this.deleteIfNeeded(MuleFoldersUtil.getDomainsFolder());
        this.deleteIfNeeded(new File(MuleFoldersUtil.getMuleLibFolder(), "shared"));
    }

    private void deleteIfNeeded(File file) {
        if (file.exists()) {
            FileUtils.deleteQuietly((File)file);
        }
    }

    @Test
    public void createClassLoaderUsingDefaultDomain() {
        this.createDomainDir("domains", "default");
        DomainDescriptor descriptor = this.getTestDescriptor("default");
        String artifactId = DomainClassLoaderFactory.getDomainId((String)"default");
        Assert.assertThat((Object)new DomainClassLoaderFactory(((Object)((Object)this)).getClass().getClassLoader(), this.getNativeLibraryFinderFactory()).create(artifactId, this.containerClassLoader, descriptor, Collections.emptyList()).getArtifactId(), (Matcher)CoreMatchers.is((Object)artifactId));
    }

    @Test
    public void createClassLoaderUsingCustomDomain() {
        String domainName = "custom-domain";
        String artifactId = DomainClassLoaderFactory.getDomainId((String)"custom-domain");
        DomainDescriptor descriptor = this.getTestDescriptor("custom-domain");
        descriptor.setRootFolder(this.createDomainDir("domains", "custom-domain"));
        ArtifactClassLoader domainClassLoader = new DomainClassLoaderFactory(((Object)((Object)this)).getClass().getClassLoader(), this.getNativeLibraryFinderFactory()).create(null, this.containerClassLoader, descriptor, Collections.emptyList());
        Assert.assertThat((Object)domainClassLoader.getClassLoader(), (Matcher)IsInstanceOf.instanceOf(MuleSharedDomainClassLoader.class));
        Assert.assertThat((Object)domainClassLoader.getArtifactId(), (Matcher)Matchers.equalTo((Object)artifactId));
    }

    @Test(expected=DeploymentException.class)
    public void validateDomainBeforeCreatingClassLoader() {
        DomainDescriptor descriptor = this.getTestDescriptor("someDomain");
        descriptor.setRootFolder(new File("unexistent"));
        new DomainClassLoaderFactory(((Object)((Object)this)).getClass().getClassLoader(), this.getNativeLibraryFinderFactory()).create(null, this.containerClassLoader, descriptor, Collections.emptyList());
    }

    @Test
    public void createClassLoaderFromDomainDescriptor() {
        String domainName = "descriptor-domain";
        String artifactId = DomainClassLoaderFactory.getDomainId((String)"descriptor-domain");
        DomainDescriptor descriptor = this.getTestDescriptor("descriptor-domain");
        descriptor.setRootFolder(this.createDomainDir("domains", "descriptor-domain"));
        ArtifactClassLoader domainClassLoader = new DomainClassLoaderFactory(((Object)((Object)this)).getClass().getClassLoader(), this.getNativeLibraryFinderFactory()).create(null, this.containerClassLoader, descriptor, Collections.emptyList());
        Assert.assertThat((Object)domainClassLoader.getClassLoader(), (Matcher)IsInstanceOf.instanceOf(MuleSharedDomainClassLoader.class));
        Assert.assertThat((Object)domainClassLoader.getArtifactId(), (Matcher)Matchers.equalTo((Object)artifactId));
    }

    @Test
    public void secondClassLoaderCreationReturnsCachedInstance() {
        String domainName = "custom-domain";
        DomainDescriptor descriptor = this.getTestDescriptor("custom-domain");
        descriptor.setRootFolder(this.createDomainDir("domains", "custom-domain"));
        DomainClassLoaderFactory factory = new DomainClassLoaderFactory(((Object)((Object)this)).getClass().getClassLoader(), this.getNativeLibraryFinderFactory());
        ArtifactClassLoader firstDomainClassLoader = factory.create(null, this.containerClassLoader, descriptor, Collections.emptyList());
        ArtifactClassLoader secondDomainClassLoader = factory.create(null, this.containerClassLoader, descriptor, Collections.emptyList());
        Assert.assertThat((Object)secondDomainClassLoader, (Matcher)CoreMatchers.is((Object)firstDomainClassLoader));
    }

    @Test
    public void secondClassLoaderCreationDoesntReturnDisposedInstance() {
        String domainName = "custom-domain";
        DomainDescriptor descriptor = this.getTestDescriptor("custom-domain");
        descriptor.setRootFolder(this.createDomainDir("domains", "custom-domain"));
        DomainClassLoaderFactory factory = new DomainClassLoaderFactory(((Object)((Object)this)).getClass().getClassLoader(), this.getNativeLibraryFinderFactory());
        ArtifactClassLoader firstDomainClassLoader = factory.create(null, this.containerClassLoader, descriptor, Collections.emptyList());
        firstDomainClassLoader.dispose();
        ArtifactClassLoader secondDomainClassLoader = factory.create(null, this.containerClassLoader, descriptor, Collections.emptyList());
        Assert.assertThat((Object)secondDomainClassLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)firstDomainClassLoader)));
    }

    @Test
    public void severalCreationsReturnCachedInstancesWhenNotDisposed() {
        String domainName = "custom-domain";
        DomainDescriptor descriptor = this.getTestDescriptor("custom-domain");
        descriptor.setRootFolder(this.createDomainDir("domains", "custom-domain"));
        DomainClassLoaderFactory factory = new DomainClassLoaderFactory(((Object)((Object)this)).getClass().getClassLoader(), this.getNativeLibraryFinderFactory());
        ArtifactClassLoader firstDomainClassLoader = factory.create(null, this.containerClassLoader, descriptor, Collections.emptyList());
        Assert.assertThat((Object)factory.create(null, this.containerClassLoader, descriptor, Collections.emptyList()), (Matcher)CoreMatchers.is((Object)firstDomainClassLoader));
        Assert.assertThat((Object)factory.create(null, this.containerClassLoader, descriptor, Collections.emptyList()), (Matcher)CoreMatchers.is((Object)firstDomainClassLoader));
        firstDomainClassLoader.dispose();
        ArtifactClassLoader secondDomainClassLoader = factory.create(null, this.containerClassLoader, descriptor, Collections.emptyList());
        Assert.assertThat((Object)secondDomainClassLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)firstDomainClassLoader)));
        Assert.assertThat((Object)factory.create(null, this.containerClassLoader, descriptor, Collections.emptyList()), (Matcher)CoreMatchers.is((Object)secondDomainClassLoader));
        Assert.assertThat((Object)factory.create(null, this.containerClassLoader, descriptor, Collections.emptyList()), (Matcher)CoreMatchers.is((Object)secondDomainClassLoader));
    }

    private DomainDescriptor getTestDescriptor(String name) {
        DomainDescriptor descriptor = new DomainDescriptor(name);
        descriptor.setRedeploymentEnabled(false);
        descriptor.setArtifactLocation(this.artifactLocation.getRoot());
        return descriptor;
    }

    private NativeLibraryFinderFactory getNativeLibraryFinderFactory() {
        return new DefaultNativeLibraryFinderFactory();
    }
}

