/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.nativelib;

import java.net.URL;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.deployment.model.internal.nativelib.ArtifactCopyNativeLibraryFinder;
import org.mule.runtime.deployment.model.internal.nativelib.DefaultNativeLibraryFinderFactory;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinder;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DefaultNativeLibraryFinderFactoryTestCase
extends AbstractMuleTestCase {
    @Rule
    public TemporaryFolder muleHomeFolder = new TemporaryFolder();
    private final DefaultNativeLibraryFinderFactory nativeLibraryFinderFactory = new DefaultNativeLibraryFinderFactory();

    @Test
    public void createsPerAppNativeLibraryFinderWhenPropertyIsFalse() throws Exception {
        this.doCreateNativeLibraryFinderTest(ArtifactCopyNativeLibraryFinder.class);
    }

    private void doCreateNativeLibraryFinderTest(Class<? extends NativeLibraryFinder> expectedNativeLibraryFinderClass) throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.home", (String)this.muleHomeFolder.getRoot().getAbsolutePath(), () -> {
            NativeLibraryFinder nativeLibraryFinder = this.nativeLibraryFinderFactory.create("testApp", UUID.randomUUID().toString(), new URL[0]);
            MatcherAssert.assertThat((Object)nativeLibraryFinder, (Matcher)Matchers.instanceOf((Class)expectedNativeLibraryFinderClass));
        });
    }
}

