/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.tooling;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.tooling.AbstractToolingClassLoaderTestCase;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFilter;

public class ToolingArtifactClassLoaderTestCase
extends AbstractToolingClassLoaderTestCase {
    @Test(expected=NullPointerException.class)
    public void createClassLoaderWithoutDelegate() {
        new ToolingArtifactClassLoader(this.regionClassLoader, null);
    }

    @Test
    public void createsClassLoaderSinglePlugin() throws Exception {
        this.regionClassLoader.addClassLoader((ArtifactClassLoader)this.pluginArtifactClassLoader, (ArtifactClassLoaderFilter)Mockito.mock(ArtifactClassLoaderFilter.class));
        ToolingArtifactClassLoader toolingArtifactClassLoader = new ToolingArtifactClassLoader(this.regionClassLoader, (ArtifactClassLoader)this.pluginArtifactClassLoader);
        MatcherAssert.assertThat((Object)this.regionClassLoader.getArtifactPluginClassLoaders().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.pluginArtifactClassLoader.disposed, (Matcher)Matchers.is((Object)false));
        toolingArtifactClassLoader.dispose();
        MatcherAssert.assertThat((Object)this.pluginArtifactClassLoader.disposed, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void createsClassLoaderMultiplePlugin() throws Exception {
        AbstractToolingClassLoaderTestCase.TestToolingPluginClassLoader anotherPluginClassLoader = new AbstractToolingClassLoaderTestCase.TestToolingPluginClassLoader(new ArtifactPluginDescriptor("test-another-plugin-descriptor"));
        this.regionClassLoader.addClassLoader((ArtifactClassLoader)anotherPluginClassLoader, (ArtifactClassLoaderFilter)Mockito.mock(ArtifactClassLoaderFilter.class));
        this.regionClassLoader.addClassLoader((ArtifactClassLoader)this.pluginArtifactClassLoader, (ArtifactClassLoaderFilter)Mockito.mock(ArtifactClassLoaderFilter.class));
        ToolingArtifactClassLoader toolingArtifactClassLoader = new ToolingArtifactClassLoader(this.regionClassLoader, (ArtifactClassLoader)this.pluginArtifactClassLoader);
        MatcherAssert.assertThat((Object)this.regionClassLoader.getArtifactPluginClassLoaders().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.pluginArtifactClassLoader.disposed, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)anotherPluginClassLoader.disposed, (Matcher)Matchers.is((Object)false));
        toolingArtifactClassLoader.dispose();
        MatcherAssert.assertThat((Object)this.pluginArtifactClassLoader.disposed, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)anotherPluginClassLoader.disposed, (Matcher)Matchers.is((Object)true));
    }
}

