/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.artifact;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.artifact.CompositeClassLoaderArtifactFinder;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.tck.size.SmallTest;

@SmallTest
public class CompositeClassLoaderArtifactFinderTestCase {
    private static final ArtifactDescriptor pluginDescriptor = new ArtifactPluginDescriptor("my-plugin");
    private static final ArtifactDescriptor appDescriptor = new ApplicationDescriptor("my-app");
    private static final ArtifactDescriptor domainDescriptor = new DomainDescriptor("my-domain");

    @Test
    public void appClassLoader() {
        ClassLoader appClassLoader = CompositeClassLoaderArtifactFinderTestCase.mockArtifactClassLoader(appDescriptor);
        CompositeClassLoader compositeClassLoader = CompositeClassLoader.from((ClassLoader)CompositeClassLoaderArtifactFinderTestCase.mockArtifactClassLoader(pluginDescriptor), (ClassLoader)appClassLoader);
        MatcherAssert.assertThat((Object)CompositeClassLoaderArtifactFinder.findClassLoader((CompositeClassLoader)compositeClassLoader), (Matcher)Matchers.equalTo((Object)appClassLoader));
    }

    @Test
    public void domainClassLoader() {
        ClassLoader domainClassLoader = CompositeClassLoaderArtifactFinderTestCase.mockArtifactClassLoader(domainDescriptor);
        CompositeClassLoader compositeClassLoader = CompositeClassLoader.from((ClassLoader)CompositeClassLoaderArtifactFinderTestCase.mockArtifactClassLoader(pluginDescriptor), (ClassLoader)domainClassLoader);
        MatcherAssert.assertThat((Object)CompositeClassLoaderArtifactFinder.findClassLoader((CompositeClassLoader)compositeClassLoader), (Matcher)Matchers.equalTo((Object)domainClassLoader));
    }

    @Test
    public void firstDelegateIfNoArtifactClassLoaderFound() {
        ClassLoader pluginClassLoader = CompositeClassLoaderArtifactFinderTestCase.mockArtifactClassLoader(pluginDescriptor);
        CompositeClassLoader compositeClassLoader = CompositeClassLoader.from((ClassLoader[])new ClassLoader[]{pluginClassLoader});
        MatcherAssert.assertThat((Object)CompositeClassLoaderArtifactFinder.findClassLoader((CompositeClassLoader)compositeClassLoader), (Matcher)Matchers.equalTo((Object)pluginClassLoader));
    }

    private static ClassLoader mockArtifactClassLoader(ArtifactDescriptor descriptor) {
        MuleDeployableArtifactClassLoader classLoader = (MuleDeployableArtifactClassLoader)Mockito.mock(MuleDeployableArtifactClassLoader.class);
        Mockito.when((Object)classLoader.getArtifactDescriptor()).thenReturn((Object)descriptor);
        return classLoader;
    }
}

