/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.application;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.builder.ApplicationClassLoaderBuilder;
import org.mule.runtime.deployment.model.api.builder.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.AbstractArtifactClassLoaderBuilder;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

public class DefaultApplicationClassLoaderBuilder
extends AbstractArtifactClassLoaderBuilder<DefaultApplicationClassLoaderBuilder>
implements ApplicationClassLoaderBuilder {
    private final DeployableArtifactClassLoaderFactory artifactClassLoaderFactory;
    private ArtifactClassLoader domainArtifactClassLoader;

    public DefaultApplicationClassLoaderBuilder(DeployableArtifactClassLoaderFactory<ApplicationDescriptor> artifactClassLoaderFactory, RegionPluginClassLoadersFactory pluginClassLoadersFactory) {
        super(pluginClassLoadersFactory);
        this.artifactClassLoaderFactory = artifactClassLoaderFactory;
    }

    @Override
    public MuleDeployableArtifactClassLoader build() {
        Preconditions.checkState((this.domainArtifactClassLoader != null ? 1 : 0) != 0, (String)"Domain cannot be null");
        return (MuleDeployableArtifactClassLoader)super.build();
    }

    @Override
    protected ArtifactClassLoader createArtifactClassLoader(String artifactId, RegionClassLoader regionClassLoader) {
        return this.artifactClassLoaderFactory.create(artifactId, (ArtifactClassLoader)regionClassLoader, this.artifactDescriptor, this.artifactPluginClassLoaders);
    }

    @Override
    protected String getArtifactId(ArtifactDescriptor artifactDescriptor) {
        return DefaultApplicationClassLoaderBuilder.getApplicationId(this.domainArtifactClassLoader.getArtifactId(), artifactDescriptor.getName());
    }

    @Override
    protected ArtifactClassLoader getParentClassLoader() {
        return this.domainArtifactClassLoader;
    }

    @Override
    public DefaultApplicationClassLoaderBuilder setDomainParentClassLoader(ArtifactClassLoader domainArtifactClassLoader) {
        this.domainArtifactClassLoader = domainArtifactClassLoader;
        return this;
    }

    public static String getApplicationId(String domainId, String applicationId) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)domainId) ? 1 : 0) != 0, (String)"domainId cannot be empty");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)applicationId) ? 1 : 0) != 0, (String)"applicationName cannot be empty");
        return domainId + "/app/" + applicationId;
    }

    @Override
    protected ClassLoaderLookupPolicy getParentLookupPolicy(ArtifactClassLoader parentClassLoader) {
        SmallMap lookupStrategies = new SmallMap();
        ArtifactDescriptor descriptor = parentClassLoader.getArtifactDescriptor();
        descriptor.getClassLoaderModel().getExportedPackages().forEach(arg_0 -> DefaultApplicationClassLoaderBuilder.lambda$getParentLookupPolicy$0((Map)lookupStrategies, arg_0));
        if (descriptor instanceof DeployableArtifactDescriptor) {
            for (ArtifactPluginDescriptor artifactPluginDescriptor : ((DeployableArtifactDescriptor)descriptor).getPlugins()) {
                artifactPluginDescriptor.getClassLoaderModel().getExportedPackages().forEach(arg_0 -> DefaultApplicationClassLoaderBuilder.lambda$getParentLookupPolicy$1((Map)lookupStrategies, arg_0));
            }
        }
        return parentClassLoader.getClassLoaderLookupPolicy().extend((Map)lookupStrategies);
    }

    private static /* synthetic */ void lambda$getParentLookupPolicy$1(Map lookupStrategies, String p) {
        lookupStrategies.put(p, ParentFirstLookupStrategy.PARENT_FIRST);
    }

    private static /* synthetic */ void lambda$getParentLookupPolicy$0(Map lookupStrategies, String p) {
        lookupStrategies.put(p, ParentFirstLookupStrategy.PARENT_FIRST);
    }
}

