/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.api.artifact.extension;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.deployment.model.api.artifact.extension.ExtensionDiscoveryRequest;
import org.mule.runtime.deployment.model.api.artifact.extension.ExtensionModelDiscoverer;
import org.mule.runtime.deployment.model.api.artifact.extension.ExtensionModelLoaderRepository;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.plugin.LoaderDescriber;
import org.mule.runtime.deployment.model.internal.artifact.extension.DefaultExtensionDiscoveryRequest;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Xml SDK")
public class ExtensionModelDiscovererTestCase
extends AbstractMuleTestCase {
    @Test
    @Issue(value="MULE-19858")
    @Description(value="Check that not only 'mule' extension is loaded for xml sdk extension model generation, but all runtime ext models are (for instance: ee)")
    public void allRuntimeExtModelsDiscoveredForExtensionLoading() {
        ArtifactPluginDescriptor descriptor = new ArtifactPluginDescriptor("myPlugin");
        LoaderDescriber loaderDescriber = new LoaderDescriber("test");
        descriptor.setExtensionModelDescriptorProperty(loaderDescriber);
        final AtomicBoolean extensionDeclared = new AtomicBoolean();
        ExtensionModelLoader extModelLoader = new ExtensionModelLoader(){

            public String getId() {
                return "test";
            }

            protected void declareExtension(ExtensionLoadingContext context) {
                extensionDeclared.set(true);
                Assert.assertThat((Object)context.getDslResolvingContext().getExtension("mule").isPresent(), (Matcher)Is.is((Object)true));
                Assert.assertThat((Object)context.getDslResolvingContext().getExtension("testRuntime").isPresent(), (Matcher)Is.is((Object)true));
                context.getExtensionDeclarer().named("test").onVersion("0.1").withCategory(Category.COMMUNITY).fromVendor("Mulesoft");
            }
        };
        ExtensionModelLoaderRepository loaderRepository = (ExtensionModelLoaderRepository)Mockito.mock(ExtensionModelLoaderRepository.class);
        Mockito.when((Object)loaderRepository.getExtensionModelLoader(loaderDescriber)).thenReturn(Optional.of(extModelLoader));
        ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
        Mockito.when((Object)artifactClassLoader.getClassLoader()).thenReturn((Object)((Object)((Object)this)).getClass().getClassLoader());
        new ExtensionModelDiscoverer().discoverPluginsExtensionModels((ExtensionDiscoveryRequest)new DefaultExtensionDiscoveryRequest(loaderRepository, Collections.singletonList(new Pair((Object)descriptor, (Object)artifactClassLoader)), Collections.emptySet(), false, false));
        Assert.assertThat((Object)extensionDeclared.get(), (Matcher)Is.is((Object)true));
    }
}

