/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.application;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.builder.DeployableArtifactClassLoaderFactoryProvider;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class MuleApplicationClassLoaderFactoryTestCase
extends AbstractMuleTestCase {
    private static final String DOMAIN_NAME = "test-domain";
    private static final String APP_NAME = "test-app";
    private static final String APP_ID = "test-app-id";
    @Rule
    public TemporaryFolder tempMuleHome = new TemporaryFolder();
    private final ArtifactClassLoader parentArtifactClassLoader = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
    private final ClassLoaderLookupPolicy classLoaderLookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);
    private final DeployableArtifactClassLoaderFactory<ApplicationDescriptor> classLoaderFactory = DeployableArtifactClassLoaderFactoryProvider.applicationClassLoaderFactory(name -> {
        try {
            return Files.createTempDirectory(name, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    });
    private String previousMuleHome;
    private ApplicationDescriptor descriptor;

    @Before
    public void createAppClassLoader() throws IOException {
        this.previousMuleHome = System.setProperty("mule.home", this.tempMuleHome.getRoot().getAbsolutePath());
        File libDir = MuleFoldersUtil.getAppLibFolder((String)APP_NAME);
        MatcherAssert.assertThat((Object)libDir.mkdirs(), (Matcher)Is.is((Object)true));
        File appLibrary = new File(libDir, "appLibrary.jar");
        FileUtils.stringToFile((String)appLibrary.getAbsolutePath(), (String)"Some text");
        Mockito.when((Object)this.classLoaderLookupPolicy.getClassLookupStrategy(ArgumentMatchers.anyString())).thenReturn((Object)ParentFirstLookupStrategy.PARENT_FIRST);
        Mockito.when((Object)this.parentArtifactClassLoader.getClassLoaderLookupPolicy()).thenReturn((Object)this.classLoaderLookupPolicy);
        Mockito.when((Object)this.parentArtifactClassLoader.getClassLoader()).thenReturn((Object)((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.classLoaderLookupPolicy.extend(ArgumentMatchers.anyMap())).thenReturn((Object)this.classLoaderLookupPolicy);
        this.descriptor = new ApplicationDescriptor(APP_NAME);
        this.descriptor.setArtifactLocation(new File(this.tempMuleHome.newFolder(), APP_NAME));
    }

    @After
    public void cleanUp() {
        if (this.previousMuleHome != null) {
            System.setProperty("mule.home", this.previousMuleHome);
        }
        FileUtils.deleteTree((File)this.tempMuleHome.getRoot());
    }

    @Test
    public void createsClassLoader() throws Exception {
        MuleApplicationClassLoader artifactClassLoader = (MuleApplicationClassLoader)this.classLoaderFactory.create(APP_ID, this.parentArtifactClassLoader, (ArtifactDescriptor)this.descriptor, Collections.emptyList());
        MatcherAssert.assertThat((Object)artifactClassLoader.getParent(), (Matcher)Is.is((Object)this.parentArtifactClassLoader.getClassLoader()));
        MatcherAssert.assertThat((Object)artifactClassLoader.getArtifactId(), (Matcher)Is.is((Object)APP_ID));
    }
}

