/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.domain;

import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.builder.DomainClassLoaderBuilder;
import org.mule.runtime.deployment.model.api.builder.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.internal.AbstractArtifactClassLoaderBuilder;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

public class DefaultDomainClassLoaderBuilder
extends AbstractArtifactClassLoaderBuilder<DefaultDomainClassLoaderBuilder>
implements DomainClassLoaderBuilder {
    private final ArtifactClassLoader parentClassLoader;
    private final DeployableArtifactClassLoaderFactory artifactClassLoaderFactory;

    public DefaultDomainClassLoaderBuilder(ArtifactClassLoader parentClassLoader, DeployableArtifactClassLoaderFactory<DomainDescriptor> artifactClassLoaderFactory, RegionPluginClassLoadersFactory pluginClassLoadersFactory) {
        super(pluginClassLoadersFactory);
        this.parentClassLoader = parentClassLoader;
        this.artifactClassLoaderFactory = artifactClassLoaderFactory;
    }

    @Override
    public MuleDeployableArtifactClassLoader build() {
        return (MuleDeployableArtifactClassLoader)super.build();
    }

    @Override
    protected ArtifactClassLoader createArtifactClassLoader(String artifactId, RegionClassLoader regionClassLoader) {
        return this.artifactClassLoaderFactory.create(artifactId, (ArtifactClassLoader)regionClassLoader, this.artifactDescriptor, this.artifactPluginClassLoaders);
    }

    @Override
    protected String getArtifactId(ArtifactDescriptor artifactDescriptor) {
        return DefaultDomainClassLoaderBuilder.getDomainId(artifactDescriptor.getName());
    }

    @Override
    protected ArtifactClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public static String getDomainId(String domainName) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)domainName) ? 1 : 0) != 0, (String)"domainName cannot be empty");
        return "/domain/" + domainName;
    }
}

