/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.artifact;

import java.util.Collections;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.deployment.model.internal.artifact.ServiceRegistryDescriptorLoaderRepository;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.api.descriptor.LoaderNotFoundException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ServiceRegistryDescriptorLoaderRepositoryTestCase
extends AbstractMuleTestCase {
    private static final String LOADER_ID = "loader";
    private final ServiceRegistry serviceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
    private final ServiceRegistryDescriptorLoaderRepository repository = new ServiceRegistryDescriptorLoaderRepository(this.serviceRegistry);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void initializesClassLoaderModelLoadersOnce() throws Exception {
        ClassLoaderModelLoader expectedClassLoaderModelLoader = (ClassLoaderModelLoader)Mockito.mock(ClassLoaderModelLoader.class);
        Mockito.when((Object)expectedClassLoaderModelLoader.getId()).thenReturn((Object)LOADER_ID);
        Set<ClassLoaderModelLoader> classLoaderModelLoaders = Collections.singleton(expectedClassLoaderModelLoader);
        Mockito.when((Object)this.serviceRegistry.lookupProviders(ClassLoaderModelLoader.class, ((Object)((Object)this)).getClass().getClassLoader())).thenReturn(classLoaderModelLoaders);
        Mockito.when((Object)expectedClassLoaderModelLoader.supportsArtifactType(ArtifactType.PLUGIN)).thenReturn((Object)true);
        this.repository.get(LOADER_ID, ArtifactType.PLUGIN, ClassLoaderModelLoader.class);
        this.repository.get(LOADER_ID, ArtifactType.PLUGIN, ClassLoaderModelLoader.class);
        ((ServiceRegistry)Mockito.verify((Object)this.serviceRegistry)).lookupProviders(ClassLoaderModelLoader.class, ((Object)((Object)this)).getClass().getClassLoader());
        ((ServiceRegistry)Mockito.verify((Object)this.serviceRegistry)).lookupProviders(BundleDescriptorLoader.class, ((Object)((Object)this)).getClass().getClassLoader());
        ((ServiceRegistry)Mockito.verify((Object)this.serviceRegistry, (VerificationMode)Mockito.never())).lookupProvider(ClassLoaderModelLoader.class, ((Object)((Object)this)).getClass().getClassLoader());
        ((ServiceRegistry)Mockito.verify((Object)this.serviceRegistry, (VerificationMode)Mockito.never())).lookupProvider(BundleDescriptorLoader.class, ((Object)((Object)this)).getClass().getClassLoader());
    }

    @Test
    public void doesNotFindInvalidLoaderId() throws Exception {
        this.expectedException.expect(LoaderNotFoundException.class);
        this.expectedException.expectMessage(ServiceRegistryDescriptorLoaderRepository.noRegisteredLoaderError((String)"invalid", ClassLoaderModelLoader.class));
        this.repository.get("invalid", ArtifactType.PLUGIN, ClassLoaderModelLoader.class);
    }

    @Test
    public void findsLoader() throws Exception {
        ClassLoaderModelLoader expectedClassLoaderModelLoader = (ClassLoaderModelLoader)Mockito.mock(ClassLoaderModelLoader.class);
        Mockito.when((Object)expectedClassLoaderModelLoader.getId()).thenReturn((Object)LOADER_ID);
        Mockito.when((Object)expectedClassLoaderModelLoader.supportsArtifactType(ArtifactType.PLUGIN)).thenReturn((Object)true);
        Set<ClassLoaderModelLoader> classLoaderModelLoaders = Collections.singleton(expectedClassLoaderModelLoader);
        Mockito.when((Object)this.serviceRegistry.lookupProviders(ClassLoaderModelLoader.class, ((Object)((Object)this)).getClass().getClassLoader())).thenReturn(classLoaderModelLoaders);
        ClassLoaderModelLoader classLoaderModelLoader = (ClassLoaderModelLoader)this.repository.get(LOADER_ID, ArtifactType.PLUGIN, ClassLoaderModelLoader.class);
        MatcherAssert.assertThat((Object)classLoaderModelLoader, (Matcher)Is.is((Object)expectedClassLoaderModelLoader));
    }

    @Test
    public void findsLoaderIdWithType() throws Exception {
        ClassLoaderModelLoader classLoaderModelLoader = (ClassLoaderModelLoader)Mockito.mock(ClassLoaderModelLoader.class);
        Mockito.when((Object)classLoaderModelLoader.getId()).thenReturn((Object)LOADER_ID);
        Set<ClassLoaderModelLoader> classLoaderModelLoaders = Collections.singleton(classLoaderModelLoader);
        Mockito.when((Object)this.serviceRegistry.lookupProviders(ClassLoaderModelLoader.class, ((Object)((Object)this)).getClass().getClassLoader())).thenReturn(classLoaderModelLoaders);
        this.expectedException.expect(LoaderNotFoundException.class);
        this.expectedException.expectMessage(ServiceRegistryDescriptorLoaderRepository.noRegisteredLoaderError((String)LOADER_ID, BundleDescriptorLoader.class));
        this.repository.get(LOADER_ID, ArtifactType.PLUGIN, BundleDescriptorLoader.class);
    }
}

