/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.artifact;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.deployment.model.internal.artifact.ServiceRegistryDescriptorLoaderRepository;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfigurationLoader;
import org.mule.runtime.module.artifact.api.descriptor.LoaderNotFoundException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@Features(value={@Feature(value="Services"), @Feature(value="Descriptor loader")})
@Story(value="Service registry")
public class ServiceRegistryDescriptorLoaderRepositoryTestCase
extends AbstractMuleTestCase {
    private static final String LOADER_ID = "loader";
    private final ServiceRegistry serviceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
    private final ServiceRegistryDescriptorLoaderRepository repository = new ServiceRegistryDescriptorLoaderRepository(this.serviceRegistry);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void initializesClassLoaderConfigurationLoadersOnce() throws Exception {
        ClassLoaderConfigurationLoader expectedClassLoaderConfigurationLoader = (ClassLoaderConfigurationLoader)Mockito.mock(ClassLoaderConfigurationLoader.class);
        Mockito.when((Object)expectedClassLoaderConfigurationLoader.getId()).thenReturn((Object)LOADER_ID);
        Set<ClassLoaderConfigurationLoader> classLoaderConfigurationLoaders = Collections.singleton(expectedClassLoaderConfigurationLoader);
        Mockito.when((Object)this.serviceRegistry.lookupProviders(ClassLoaderConfigurationLoader.class, ((Object)((Object)this)).getClass().getClassLoader())).thenReturn(classLoaderConfigurationLoaders);
        Mockito.when((Object)expectedClassLoaderConfigurationLoader.supportsArtifactType(ArtifactType.PLUGIN)).thenReturn((Object)true);
        this.repository.get(LOADER_ID, ArtifactType.PLUGIN, ClassLoaderConfigurationLoader.class);
        this.repository.get(LOADER_ID, ArtifactType.PLUGIN, ClassLoaderConfigurationLoader.class);
        ((ServiceRegistry)Mockito.verify((Object)this.serviceRegistry)).lookupProviders(ClassLoaderConfigurationLoader.class, ((Object)((Object)this)).getClass().getClassLoader());
        ((ServiceRegistry)Mockito.verify((Object)this.serviceRegistry)).lookupProviders(BundleDescriptorLoader.class, ((Object)((Object)this)).getClass().getClassLoader());
        ((ServiceRegistry)Mockito.verify((Object)this.serviceRegistry, (VerificationMode)Mockito.never())).lookupProvider(ClassLoaderConfigurationLoader.class, ((Object)((Object)this)).getClass().getClassLoader());
        ((ServiceRegistry)Mockito.verify((Object)this.serviceRegistry, (VerificationMode)Mockito.never())).lookupProvider(BundleDescriptorLoader.class, ((Object)((Object)this)).getClass().getClassLoader());
    }

    @Test
    public void doesNotFindInvalidLoaderId() throws Exception {
        this.expectedException.expect(LoaderNotFoundException.class);
        this.expectedException.expectMessage(ServiceRegistryDescriptorLoaderRepository.noRegisteredLoaderError((String)"invalid", ClassLoaderConfigurationLoader.class));
        this.repository.get("invalid", ArtifactType.PLUGIN, ClassLoaderConfigurationLoader.class);
    }

    @Test
    public void findsLoader() throws Exception {
        ClassLoaderConfigurationLoader expectedClassLoaderConfigurationLoader = (ClassLoaderConfigurationLoader)Mockito.mock(ClassLoaderConfigurationLoader.class);
        Mockito.when((Object)expectedClassLoaderConfigurationLoader.getId()).thenReturn((Object)LOADER_ID);
        Mockito.when((Object)expectedClassLoaderConfigurationLoader.supportsArtifactType(ArtifactType.PLUGIN)).thenReturn((Object)true);
        Set<ClassLoaderConfigurationLoader> classLoaderConfigurationLoaders = Collections.singleton(expectedClassLoaderConfigurationLoader);
        Mockito.when((Object)this.serviceRegistry.lookupProviders(ClassLoaderConfigurationLoader.class, ((Object)((Object)this)).getClass().getClassLoader())).thenReturn(classLoaderConfigurationLoaders);
        ClassLoaderConfigurationLoader classLoaderConfigurationLoader = (ClassLoaderConfigurationLoader)this.repository.get(LOADER_ID, ArtifactType.PLUGIN, ClassLoaderConfigurationLoader.class);
        MatcherAssert.assertThat((Object)classLoaderConfigurationLoader, (Matcher)Is.is((Object)expectedClassLoaderConfigurationLoader));
    }

    @Test
    public void findsLoaderIdWithType() throws Exception {
        ClassLoaderConfigurationLoader classLoaderConfigurationLoader = (ClassLoaderConfigurationLoader)Mockito.mock(ClassLoaderConfigurationLoader.class);
        Mockito.when((Object)classLoaderConfigurationLoader.getId()).thenReturn((Object)LOADER_ID);
        Set<ClassLoaderConfigurationLoader> classLoaderConfigurationLoaders = Collections.singleton(classLoaderConfigurationLoader);
        Mockito.when((Object)this.serviceRegistry.lookupProviders(ClassLoaderConfigurationLoader.class, ((Object)((Object)this)).getClass().getClassLoader())).thenReturn(classLoaderConfigurationLoaders);
        this.expectedException.expect(LoaderNotFoundException.class);
        this.expectedException.expectMessage(ServiceRegistryDescriptorLoaderRepository.noRegisteredLoaderError((String)LOADER_ID, BundleDescriptorLoader.class));
        this.repository.get(LOADER_ID, ArtifactType.PLUGIN, BundleDescriptorLoader.class);
    }
}

