/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.artifact.activation.internal;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.net.URL;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.artifact.activation.internal.TrackingArtifactClassLoaderResolverDecorator;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginDescriptorResolver;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Issue(value="W-11069995")
@Feature(value="Classloading Isolation")
@Story(value="ClassLoader generation")
public class TrackingArtifactClassLoaderResolverDecoratorTestCase
extends AbstractMuleTestCase {
    private ArtifactClassLoaderManager artifactClassLoaderManager;
    private TrackingArtifactClassLoaderResolverDecorator decorator;

    @Before
    public void setUp() throws Exception {
        this.artifactClassLoaderManager = (ArtifactClassLoaderManager)Mockito.mock(ArtifactClassLoaderManager.class);
        ArtifactClassLoaderResolver artifactClassLoaderResolver = (ArtifactClassLoaderResolver)Mockito.mock(ArtifactClassLoaderResolver.class);
        this.decorator = new TrackingArtifactClassLoaderResolverDecorator(this.artifactClassLoaderManager, artifactClassLoaderResolver);
        Function<String, MuleDeployableArtifactClassLoader> classLoaderFactory = artifactName -> new MuleDeployableArtifactClassLoader(artifactName, new ArtifactDescriptor(artifactName), new URL[0], (ClassLoader)Mockito.mock(RegionClassLoader.class), (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class));
        Function<String, MuleDeployableArtifactClassLoader> classLoaderWithPluginsFactory = artifactName -> {
            MuleDeployableArtifactClassLoader classLoader = (MuleDeployableArtifactClassLoader)classLoaderFactory.apply((String)artifactName);
            ArrayList<ArtifactClassLoader> pluginClassLoaders = new ArrayList<ArtifactClassLoader>();
            pluginClassLoaders.add((ArtifactClassLoader)classLoaderFactory.apply(artifactName + " Plugin Class loader 1"));
            pluginClassLoaders.add((ArtifactClassLoader)classLoaderFactory.apply(artifactName + " Plugin Class loader 2"));
            Mockito.when((Object)classLoader.getArtifactPluginClassLoaders()).thenReturn(pluginClassLoaders);
            return classLoader;
        };
        MuleDeployableArtifactClassLoader domainClassLoader1 = classLoaderWithPluginsFactory.apply("Domain Class loader 1");
        MuleDeployableArtifactClassLoader domainClassLoader2 = classLoaderWithPluginsFactory.apply("Domain Class loader 2");
        MuleDeployableArtifactClassLoader applicationClassLoader1 = classLoaderWithPluginsFactory.apply("Application Class loader 1");
        MuleDeployableArtifactClassLoader applicationClassLoader2 = classLoaderWithPluginsFactory.apply("Application Class loader 2");
        MuleDeployableArtifactClassLoader applicationClassLoader3 = classLoaderWithPluginsFactory.apply("Application Class loader 3");
        MuleDeployableArtifactClassLoader applicationClassLoader4 = classLoaderWithPluginsFactory.apply("Application Class loader 4");
        MuleDeployableArtifactClassLoader pluginClassLoader1 = classLoaderWithPluginsFactory.apply("Plugin Class loader 1");
        MuleDeployableArtifactClassLoader pluginClassLoader2 = classLoaderWithPluginsFactory.apply("Plugin Class loader 2");
        Mockito.when((Object)artifactClassLoaderResolver.createDomainClassLoader((DomainDescriptor)ArgumentMatchers.any())).thenReturn((Object)domainClassLoader1);
        Mockito.when((Object)artifactClassLoaderResolver.createDomainClassLoader((DomainDescriptor)ArgumentMatchers.any(), (PluginClassLoaderResolver)ArgumentMatchers.any())).thenReturn((Object)domainClassLoader2);
        Mockito.when((Object)artifactClassLoaderResolver.createApplicationClassLoader((ApplicationDescriptor)ArgumentMatchers.any())).thenReturn((Object)applicationClassLoader1);
        Mockito.when((Object)artifactClassLoaderResolver.createApplicationClassLoader((ApplicationDescriptor)ArgumentMatchers.any(), (PluginClassLoaderResolver)ArgumentMatchers.any(PluginClassLoaderResolver.class))).thenReturn((Object)applicationClassLoader2);
        Mockito.when((Object)artifactClassLoaderResolver.createApplicationClassLoader((ApplicationDescriptor)ArgumentMatchers.any(), (Supplier)ArgumentMatchers.any(Supplier.class))).thenReturn((Object)applicationClassLoader3);
        Mockito.when((Object)artifactClassLoaderResolver.createApplicationClassLoader((ApplicationDescriptor)ArgumentMatchers.any(), (Supplier)ArgumentMatchers.any(), (PluginClassLoaderResolver)ArgumentMatchers.any(PluginClassLoaderResolver.class))).thenReturn((Object)applicationClassLoader4);
        Mockito.when((Object)artifactClassLoaderResolver.createMulePluginClassLoader((MuleDeployableArtifactClassLoader)ArgumentMatchers.any(), (ArtifactPluginDescriptor)ArgumentMatchers.any(), (PluginDescriptorResolver)ArgumentMatchers.any())).thenReturn((Object)pluginClassLoader1);
        Mockito.when((Object)artifactClassLoaderResolver.createMulePluginClassLoader((MuleDeployableArtifactClassLoader)ArgumentMatchers.any(), (ArtifactPluginDescriptor)ArgumentMatchers.any(), (PluginDescriptorResolver)ArgumentMatchers.any(), (PluginClassLoaderResolver)ArgumentMatchers.any())).thenReturn((Object)pluginClassLoader2);
    }

    @Test
    public void registersClassLoaders() {
        this.verifyClassLoaderRegistered(this.decorator.createDomainClassLoader((DomainDescriptor)Mockito.mock(DomainDescriptor.class)));
        this.verifyClassLoaderRegistered(this.decorator.createDomainClassLoader((DomainDescriptor)Mockito.mock(DomainDescriptor.class), (PluginClassLoaderResolver)Mockito.mock(PluginClassLoaderResolver.class)));
        this.verifyClassLoaderRegistered(this.decorator.createApplicationClassLoader((ApplicationDescriptor)Mockito.mock(ApplicationDescriptor.class)));
        this.verifyClassLoaderRegistered(this.decorator.createApplicationClassLoader((ApplicationDescriptor)Mockito.mock(ApplicationDescriptor.class), (PluginClassLoaderResolver)Mockito.mock(PluginClassLoaderResolver.class)));
        this.verifyClassLoaderRegistered(this.decorator.createApplicationClassLoader((ApplicationDescriptor)Mockito.mock(ApplicationDescriptor.class), (Supplier)Mockito.mock(Supplier.class)));
        this.verifyClassLoaderRegistered(this.decorator.createApplicationClassLoader((ApplicationDescriptor)Mockito.mock(ApplicationDescriptor.class), (Supplier)Mockito.mock(Supplier.class), (PluginClassLoaderResolver)Mockito.mock(PluginClassLoaderResolver.class)));
        this.verifyClassLoaderRegistered(this.decorator.createMulePluginClassLoader((MuleDeployableArtifactClassLoader)Mockito.mock(MuleDeployableArtifactClassLoader.class), (ArtifactPluginDescriptor)Mockito.mock(ArtifactPluginDescriptor.class), (PluginDescriptorResolver)Mockito.mock(PluginDescriptorResolver.class)));
        this.verifyClassLoaderRegistered(this.decorator.createMulePluginClassLoader((MuleDeployableArtifactClassLoader)Mockito.mock(MuleDeployableArtifactClassLoader.class), (ArtifactPluginDescriptor)Mockito.mock(ArtifactPluginDescriptor.class), (PluginDescriptorResolver)Mockito.mock(PluginDescriptorResolver.class), (PluginClassLoaderResolver)Mockito.mock(PluginClassLoaderResolver.class)));
    }

    private void verifyClassLoaderRegistered(MuleArtifactClassLoader classLoader) {
        ((ArtifactClassLoaderManager)Mockito.verify((Object)this.artifactClassLoaderManager)).register((ArtifactClassLoader)classLoader);
    }

    private void verifyClassLoaderRegistered(MuleDeployableArtifactClassLoader classLoader) {
        ((ArtifactClassLoaderManager)Mockito.verify((Object)this.artifactClassLoaderManager)).register((ArtifactClassLoader)classLoader);
        classLoader.getArtifactPluginClassLoaders().forEach(pcl -> ((ArtifactClassLoaderManager)Mockito.verify((Object)this.artifactClassLoaderManager)).register(pcl));
    }

    @Test
    public void disposesClassLoaders() {
        this.verifyClassLoaderDisposed(this.decorator.createDomainClassLoader((DomainDescriptor)Mockito.mock(DomainDescriptor.class)));
        this.verifyClassLoaderDisposed(this.decorator.createDomainClassLoader((DomainDescriptor)Mockito.mock(DomainDescriptor.class), (PluginClassLoaderResolver)Mockito.mock(PluginClassLoaderResolver.class)));
        this.verifyClassLoaderDisposed(this.decorator.createApplicationClassLoader((ApplicationDescriptor)Mockito.mock(ApplicationDescriptor.class)));
        this.verifyClassLoaderDisposed(this.decorator.createApplicationClassLoader((ApplicationDescriptor)Mockito.mock(ApplicationDescriptor.class), (PluginClassLoaderResolver)Mockito.mock(PluginClassLoaderResolver.class)));
        this.verifyClassLoaderDisposed(this.decorator.createApplicationClassLoader((ApplicationDescriptor)Mockito.mock(ApplicationDescriptor.class), (Supplier)Mockito.mock(Supplier.class)));
        this.verifyClassLoaderDisposed(this.decorator.createApplicationClassLoader((ApplicationDescriptor)Mockito.mock(ApplicationDescriptor.class), (Supplier)Mockito.mock(Supplier.class), (PluginClassLoaderResolver)Mockito.mock(PluginClassLoaderResolver.class)));
        this.verifyClassLoaderDisposed(this.decorator.createMulePluginClassLoader((MuleDeployableArtifactClassLoader)Mockito.mock(MuleDeployableArtifactClassLoader.class), (ArtifactPluginDescriptor)Mockito.mock(ArtifactPluginDescriptor.class), (PluginDescriptorResolver)Mockito.mock(PluginDescriptorResolver.class)));
        this.verifyClassLoaderDisposed(this.decorator.createMulePluginClassLoader((MuleDeployableArtifactClassLoader)Mockito.mock(MuleDeployableArtifactClassLoader.class), (ArtifactPluginDescriptor)Mockito.mock(ArtifactPluginDescriptor.class), (PluginDescriptorResolver)Mockito.mock(PluginDescriptorResolver.class), (PluginClassLoaderResolver)Mockito.mock(PluginClassLoaderResolver.class)));
    }

    private void verifyClassLoaderDisposed(MuleArtifactClassLoader classLoader) {
        classLoader.dispose();
        ((ArtifactClassLoaderManager)Mockito.verify((Object)this.artifactClassLoaderManager)).unregister(classLoader.getArtifactId());
    }

    private void verifyClassLoaderDisposed(MuleDeployableArtifactClassLoader classLoader) {
        classLoader.dispose();
        ((ArtifactClassLoaderManager)Mockito.verify((Object)this.artifactClassLoaderManager)).unregister(classLoader.getArtifactId());
        classLoader.getArtifactPluginClassLoaders().forEach(pcl -> {
            pcl.dispose();
            ((ArtifactClassLoaderManager)Mockito.verify((Object)this.artifactClassLoaderManager)).unregister(pcl.getArtifactId());
        });
    }
}

