/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mule.runtime.container.api.ContainerClassLoaderProvider;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerOnlyLookupStrategy;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.internal.classloader.DefaultArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DelegateOnlyLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Classloading Isolation")
@Story(value="ClassLoader generation")
public class DefaultRegionPluginClassLoadersFactoryTestCase
extends AbstractMuleTestCase {
    private static final String REGION_ID = "regionId";
    private static final String PRIVILEGED_PACKAGE = "org.foo.privileged";
    private static final String GROUP_ID = "org.mule.test";
    private static final String PLUGIN_ID2 = "plugin2";
    private static final String PLUGIN_ARTIFACT_ID2 = "org.mule.test:plugin2";
    private static final String PLUGIN_ID1 = "plugin1";
    private static final String PLUGIN_ARTIFACT_ID1 = "org.mule.test:plugin1";
    private static final BundleDescriptor PLUGIN1_BUNDLE_DESCRIPTOR = new BundleDescriptor.Builder().setGroupId("org.mule.test").setArtifactId("plugin1").setVersion("1.0").setClassifier("mule-plugin").build();
    private static final BundleDescriptor PLUGIN2_BUNDLE_DESCRIPTOR = new BundleDescriptor.Builder().setGroupId("org.mule.test").setArtifactId("plugin2").setVersion("1.0").setClassifier("mule-plugin").build();
    private final ModuleRepository moduleRepository = (ModuleRepository)Mockito.mock(ModuleRepository.class);
    private final ArtifactClassLoader containerClassLoader = ContainerClassLoaderProvider.createContainerClassLoader((ModuleRepository)this.moduleRepository);
    private final DefaultRegionPluginClassLoadersFactory factory = new DefaultRegionPluginClassLoadersFactory((ArtifactClassLoaderResolver)new DefaultArtifactClassLoaderResolver(this.containerClassLoader, this.moduleRepository, null));
    private final ClassLoaderLookupPolicy regionOwnerLookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);
    private MuleDeployableArtifactClassLoader artifactClassLoader;
    private RegionClassLoader regionClassLoader;
    private final ArtifactPluginDescriptor plugin1Descriptor = new ArtifactPluginDescriptor("plugin1");
    private final ArtifactPluginDescriptor plugin2Descriptor = new ArtifactPluginDescriptor("plugin2");
    private final ArtifactClassLoader pluginClassLoader1 = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
    private final ArtifactClassLoader pluginClassLoader2 = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
    private final ClassLoaderLookupPolicy pluginLookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);

    @Before
    public void setUp() throws Exception {
        this.regionClassLoader = new RegionClassLoader(REGION_ID, (ArtifactDescriptor)Mockito.mock(ArtifactDescriptor.class), ((Object)((Object)this)).getClass().getClassLoader(), this.regionOwnerLookupPolicy);
        this.artifactClassLoader = new MuleDeployableArtifactClassLoader(REGION_ID, (ArtifactDescriptor)Mockito.mock(ArtifactDescriptor.class), new URL[0], (ClassLoader)this.regionClassLoader, this.regionOwnerLookupPolicy);
        this.regionClassLoader.addClassLoader((ArtifactClassLoader)this.artifactClassLoader, (ArtifactClassLoaderFilter)Mockito.mock(ArtifactClassLoaderFilter.class));
        this.plugin1Descriptor.setBundleDescriptor(PLUGIN1_BUNDLE_DESCRIPTOR);
        this.plugin2Descriptor.setBundleDescriptor(PLUGIN2_BUNDLE_DESCRIPTOR);
        Mockito.when((Object)this.pluginClassLoader1.getClassLoader()).thenReturn((Object)((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.pluginClassLoader1.getArtifactDescriptor()).thenReturn((Object)this.plugin1Descriptor);
        Mockito.when((Object)this.pluginClassLoader2.getClassLoader()).thenReturn((Object)((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.pluginClassLoader2.getArtifactDescriptor()).thenReturn((Object)this.plugin2Descriptor);
    }

    @Test
    public void createsNoPlugins() {
        List pluginClassLoaders = this.factory.createPluginClassLoaders((ArtifactClassLoader)this.regionClassLoader, Collections.emptyList(), this.regionOwnerLookupPolicy);
        MatcherAssert.assertThat((Object)pluginClassLoaders, (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void createsSinglePlugin() {
        List<ArtifactPluginDescriptor> artifactPluginDescriptors = Collections.singletonList(this.plugin1Descriptor);
        ClassLoaderLookupPolicy pluginBaseLookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);
        Mockito.when((Object)this.regionOwnerLookupPolicy.extend((Stream)MockitoHamcrest.argThat((Matcher)Matchers.any(Stream.class)), (LookupStrategy)MockitoHamcrest.argThat((Matcher)Matchers.any(LookupStrategy.class)))).thenReturn((Object)pluginBaseLookupPolicy);
        Mockito.when((Object)pluginBaseLookupPolicy.extend((Map)MockitoHamcrest.argThat((Matcher)Matchers.any(Map.class)))).thenReturn((Object)pluginBaseLookupPolicy);
        Mockito.when((Object)pluginBaseLookupPolicy.extend((Stream)MockitoHamcrest.argThat((Matcher)Matchers.any(Stream.class)), (LookupStrategy)MockitoHamcrest.argThat((Matcher)Matchers.any(LookupStrategy.class)), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)this.pluginLookupPolicy);
        List pluginClassLoaders = this.factory.createPluginClassLoaders((ArtifactClassLoader)this.regionClassLoader, artifactPluginDescriptors, this.regionOwnerLookupPolicy);
        MatcherAssert.assertThat(pluginClassLoaders.stream().map(ArtifactClassLoader::getArtifactDescriptor).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new Object[]{this.pluginClassLoader1.getArtifactDescriptor()}));
    }

    @Test
    public void createsIndependentPlugins() {
        ArrayList<ArtifactPluginDescriptor> artifactPluginDescriptors = new ArrayList<ArtifactPluginDescriptor>();
        artifactPluginDescriptors.add(this.plugin1Descriptor);
        artifactPluginDescriptors.add(this.plugin2Descriptor);
        ClassLoaderLookupPolicy pluginBaseLookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);
        Mockito.when((Object)this.regionOwnerLookupPolicy.extend((Stream)MockitoHamcrest.argThat((Matcher)Matchers.any(Stream.class)), (LookupStrategy)MockitoHamcrest.argThat((Matcher)Matchers.any(LookupStrategy.class)))).thenReturn((Object)pluginBaseLookupPolicy);
        Mockito.when((Object)pluginBaseLookupPolicy.extend((Map)MockitoHamcrest.argThat((Matcher)Matchers.any(Map.class)))).thenReturn((Object)pluginBaseLookupPolicy);
        Mockito.when((Object)pluginBaseLookupPolicy.extend((Stream)MockitoHamcrest.argThat((Matcher)Matchers.any(Stream.class)), (LookupStrategy)MockitoHamcrest.argThat((Matcher)Matchers.any(LookupStrategy.class)), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)this.pluginLookupPolicy);
        List pluginClassLoaders = this.factory.createPluginClassLoaders((ArtifactClassLoader)this.regionClassLoader, artifactPluginDescriptors, this.regionOwnerLookupPolicy);
        MatcherAssert.assertThat(pluginClassLoaders.stream().map(ArtifactClassLoader::getArtifactDescriptor).collect(Collectors.toList()), (Matcher)Matchers.contains(Arrays.asList(Matchers.equalTo((Object)this.pluginClassLoader1.getArtifactDescriptor()), Matchers.equalTo((Object)this.pluginClassLoader2.getArtifactDescriptor()))));
    }

    @Test
    public void createsDependantPlugins() {
        BundleDependency pluginDependency = new BundleDependency.Builder().setScope(BundleScope.COMPILE).setDescriptor(PLUGIN1_BUNDLE_DESCRIPTOR).setBundleUri(new File("test").toURI()).build();
        this.plugin2Descriptor.setClassLoaderConfiguration(new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder().dependingOn(Collections.singleton(pluginDependency)).build());
        ArrayList<ArtifactPluginDescriptor> artifactPluginDescriptors = new ArrayList<ArtifactPluginDescriptor>();
        artifactPluginDescriptors.add(this.plugin1Descriptor);
        artifactPluginDescriptors.add(this.plugin2Descriptor);
        ClassLoaderLookupPolicy pluginBaseLookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);
        Mockito.when((Object)this.regionOwnerLookupPolicy.extend((Stream)MockitoHamcrest.argThat((Matcher)Matchers.any(Stream.class)), (LookupStrategy)MockitoHamcrest.argThat((Matcher)Matchers.any(LookupStrategy.class)))).thenReturn((Object)pluginBaseLookupPolicy);
        Mockito.when((Object)pluginBaseLookupPolicy.extend((Map)MockitoHamcrest.argThat((Matcher)Matchers.any(Map.class)))).thenReturn((Object)pluginBaseLookupPolicy);
        Mockito.when((Object)pluginBaseLookupPolicy.extend((Stream)MockitoHamcrest.argThat((Matcher)Matchers.any(Stream.class)), (LookupStrategy)MockitoHamcrest.argThat((Matcher)Matchers.any(LookupStrategy.class)), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)this.pluginLookupPolicy);
        List pluginClassLoaders = this.factory.createPluginClassLoaders((ArtifactClassLoader)this.regionClassLoader, artifactPluginDescriptors, this.regionOwnerLookupPolicy);
        MatcherAssert.assertThat(pluginClassLoaders.stream().map(ArtifactClassLoader::getArtifactDescriptor).collect(Collectors.toList()), (Matcher)Matchers.contains(Arrays.asList(Matchers.equalTo((Object)this.pluginClassLoader1.getArtifactDescriptor()), Matchers.equalTo((Object)this.pluginClassLoader2.getArtifactDescriptor()))));
    }

    @Test
    public void createsPluginWithPrivilegedContainerAccess() {
        MuleModule privilegedModule = (MuleModule)Mockito.mock(MuleModule.class);
        Mockito.when((Object)privilegedModule.getPrivilegedArtifacts()).thenReturn(Collections.singleton(PLUGIN_ARTIFACT_ID1));
        Mockito.when((Object)privilegedModule.getPrivilegedExportedPackages()).thenReturn(Collections.singleton(PRIVILEGED_PACKAGE));
        Mockito.when((Object)this.moduleRepository.getModules()).thenReturn(Collections.singletonList(privilegedModule));
        List<ArtifactPluginDescriptor> artifactPluginDescriptors = Collections.singletonList(this.plugin1Descriptor);
        ClassLoaderLookupPolicy pluginBaseLookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);
        ArgumentCaptor mapArgumentCaptor = ArgumentCaptor.forClass(Map.class);
        Mockito.when((Object)this.regionOwnerLookupPolicy.extend((Stream)MockitoHamcrest.argThat((Matcher)Matchers.any(Stream.class)), (LookupStrategy)MockitoHamcrest.argThat((Matcher)Matchers.any(LookupStrategy.class)))).thenReturn((Object)pluginBaseLookupPolicy);
        Mockito.when((Object)pluginBaseLookupPolicy.extend((Map)mapArgumentCaptor.capture())).thenReturn((Object)pluginBaseLookupPolicy);
        Mockito.when((Object)pluginBaseLookupPolicy.extend((Stream)MockitoHamcrest.argThat((Matcher)Matchers.any(Stream.class)), (LookupStrategy)MockitoHamcrest.argThat((Matcher)Matchers.any(LookupStrategy.class)), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)this.pluginLookupPolicy);
        List pluginClassLoaders = this.factory.createPluginClassLoaders((ArtifactClassLoader)this.regionClassLoader, artifactPluginDescriptors, this.regionOwnerLookupPolicy);
        MatcherAssert.assertThat(pluginClassLoaders.stream().map(ArtifactClassLoader::getArtifactDescriptor).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new Object[]{this.pluginClassLoader1.getArtifactDescriptor()}));
        Map value = (Map)mapArgumentCaptor.getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)PRIVILEGED_PACKAGE), (Matcher)Matchers.instanceOf(ContainerOnlyLookupStrategy.class)));
    }

    @Test
    public void createsPluginWithPrivilegedPluginAccess() {
        ClassLoaderConfiguration plugin1ClassLoaderConfiguration = new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder().exportingPrivilegedPackages(Collections.singleton(PRIVILEGED_PACKAGE), Collections.singleton(PLUGIN_ARTIFACT_ID2)).build();
        this.plugin1Descriptor.setClassLoaderConfiguration(plugin1ClassLoaderConfiguration);
        BundleDependency pluginDependency = new BundleDependency.Builder().setScope(BundleScope.COMPILE).setDescriptor(PLUGIN1_BUNDLE_DESCRIPTOR).setBundleUri(new File("test").toURI()).build();
        this.plugin2Descriptor.setClassLoaderConfiguration(new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder().dependingOn(Collections.singleton(pluginDependency)).build());
        ArrayList<ArtifactPluginDescriptor> artifactPluginDescriptors = new ArrayList<ArtifactPluginDescriptor>();
        artifactPluginDescriptors.add(this.plugin1Descriptor);
        artifactPluginDescriptors.add(this.plugin2Descriptor);
        ClassLoaderLookupPolicy pluginBaseLookupPolicy = (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class);
        ArgumentCaptor mapArgumentCaptor = ArgumentCaptor.forClass(Map.class);
        Mockito.when((Object)this.regionOwnerLookupPolicy.extend((Stream)MockitoHamcrest.argThat((Matcher)Matchers.any(Stream.class)), (LookupStrategy)MockitoHamcrest.argThat((Matcher)Matchers.any(LookupStrategy.class)))).thenReturn((Object)pluginBaseLookupPolicy);
        Mockito.when((Object)pluginBaseLookupPolicy.extend((Map)mapArgumentCaptor.capture())).thenReturn((Object)pluginBaseLookupPolicy);
        Mockito.when((Object)pluginBaseLookupPolicy.extend((Stream)MockitoHamcrest.argThat((Matcher)Matchers.any(Stream.class)), (LookupStrategy)MockitoHamcrest.argThat((Matcher)Matchers.any(LookupStrategy.class)), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)this.pluginLookupPolicy);
        List pluginClassLoaders = this.factory.createPluginClassLoaders((ArtifactClassLoader)this.regionClassLoader, artifactPluginDescriptors, this.regionOwnerLookupPolicy);
        MatcherAssert.assertThat(pluginClassLoaders.stream().map(ArtifactClassLoader::getArtifactDescriptor).collect(Collectors.toList()), (Matcher)Matchers.contains(Arrays.asList(Matchers.equalTo((Object)this.pluginClassLoader1.getArtifactDescriptor()), Matchers.equalTo((Object)this.pluginClassLoader2.getArtifactDescriptor()))));
        MatcherAssert.assertThat((Object)((Map)mapArgumentCaptor.getAllValues().get(0)), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)PRIVILEGED_PACKAGE), (Matcher)Matchers.instanceOf(DelegateOnlyLookupStrategy.class))));
        MatcherAssert.assertThat((Object)((Map)mapArgumentCaptor.getAllValues().get(1)), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)PRIVILEGED_PACKAGE), (Matcher)Matchers.instanceOf(DelegateOnlyLookupStrategy.class)));
    }
}

