/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.domain;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.runtime.container.api.ContainerClassLoaderProvider;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.api.builder.DeployableArtifactClassLoaderFactoryProvider;
import org.mule.runtime.deployment.model.internal.domain.DefaultDomainClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.domain.DomainClassLoaderFactory;
import org.mule.runtime.deployment.model.internal.domain.test.AbstractDomainTestCase;
import org.mule.runtime.module.artifact.activation.api.ArtifactActivationException;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.internal.classloader.DefaultArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.internal.classloader.MuleSharedDomainClassLoader;
import org.mule.runtime.module.artifact.activation.internal.nativelib.DefaultNativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;

public class DomainClassLoaderFactoryTestCase
extends AbstractDomainTestCase {
    @Rule
    public TemporaryFolder artifactLocation = new TemporaryFolder();

    @After
    public void tearDown() {
        this.deleteIfNeeded(MuleFoldersUtil.getDomainsFolder());
        this.deleteIfNeeded(new File(MuleFoldersUtil.getMuleLibFolder(), "shared"));
    }

    private void deleteIfNeeded(File file) {
        if (file.exists()) {
            FileUtils.deleteQuietly((File)file);
        }
    }

    @Test
    public void createClassLoaderUsingDefaultDomain() {
        this.createDomainDir("domains", "default");
        DomainDescriptor descriptor = this.getTestDescriptor("default");
        String artifactId = DomainClassLoaderFactory.getDomainId((String)"default");
        Assert.assertThat((Object)DeployableArtifactClassLoaderFactoryProvider.domainClassLoaderFactory(name -> MuleFoldersUtil.getAppDataFolder((String)name)).create(artifactId, this.containerClassLoader, (ArtifactDescriptor)descriptor, Collections.emptyList()).getArtifactId(), (Matcher)CoreMatchers.is((Object)artifactId));
    }

    @Test
    public void createClassLoaderUsingCustomDomain() {
        String domainName = "custom-domain";
        String artifactId = DomainClassLoaderFactory.getDomainId((String)"custom-domain");
        DomainDescriptor descriptor = this.getTestDescriptor("custom-domain");
        descriptor.setRootFolder(this.createDomainDir("domains", "custom-domain"));
        ArtifactClassLoader domainClassLoader = DeployableArtifactClassLoaderFactoryProvider.domainClassLoaderFactory(name -> MuleFoldersUtil.getAppDataFolder((String)name)).create(null, this.containerClassLoader, (ArtifactDescriptor)descriptor, Collections.emptyList());
        Assert.assertThat((Object)domainClassLoader.getClassLoader(), (Matcher)IsInstanceOf.instanceOf(MuleSharedDomainClassLoader.class));
        Assert.assertThat((Object)domainClassLoader.getArtifactId(), (Matcher)Matchers.equalTo((Object)artifactId));
    }

    @Test(expected=ArtifactActivationException.class)
    public void validateDomainBeforeCreatingClassLoader() {
        DomainDescriptor descriptor = this.getTestDescriptor("someDomain");
        descriptor.setRootFolder(new File("unexistent"));
        ModuleRepository moduleRepository = (ModuleRepository)Mockito.mock(ModuleRepository.class);
        DefaultArtifactClassLoaderResolver artifactClassLoaderResolver = new DefaultArtifactClassLoaderResolver(ContainerClassLoaderProvider.createContainerClassLoader((ModuleRepository)moduleRepository), moduleRepository, (NativeLibraryFinderFactory)new DefaultNativeLibraryFinderFactory(name -> MuleFoldersUtil.getAppDataFolder((String)name)));
        DefaultDomainClassLoaderBuilder domainClassLoaderBuilder = new DefaultDomainClassLoaderBuilder((ArtifactClassLoaderResolver)artifactClassLoaderResolver);
        domainClassLoaderBuilder.setArtifactDescriptor((ArtifactDescriptor)descriptor);
        domainClassLoaderBuilder.build();
    }

    @Test
    public void createClassLoaderFromDomainDescriptor() {
        String domainName = "descriptor-domain";
        String artifactId = DomainClassLoaderFactory.getDomainId((String)"descriptor-domain");
        DomainDescriptor descriptor = this.getTestDescriptor("descriptor-domain");
        descriptor.setRootFolder(this.createDomainDir("domains", "descriptor-domain"));
        ArtifactClassLoader domainClassLoader = DeployableArtifactClassLoaderFactoryProvider.domainClassLoaderFactory(name -> MuleFoldersUtil.getAppDataFolder((String)name)).create(null, this.containerClassLoader, (ArtifactDescriptor)descriptor, Collections.emptyList());
        Assert.assertThat((Object)domainClassLoader.getClassLoader(), (Matcher)IsInstanceOf.instanceOf(MuleSharedDomainClassLoader.class));
        Assert.assertThat((Object)domainClassLoader.getArtifactId(), (Matcher)Matchers.equalTo((Object)artifactId));
    }

    @Test
    public void secondClassLoaderCreationReturnsCachedInstance() {
        String domainName = "custom-domain";
        DomainDescriptor descriptor = this.getTestDescriptor("custom-domain");
        descriptor.setRootFolder(this.createDomainDir("domains", "custom-domain"));
        DeployableArtifactClassLoaderFactory factory = DeployableArtifactClassLoaderFactoryProvider.domainClassLoaderFactory(name -> MuleFoldersUtil.getAppDataFolder((String)name));
        ArtifactClassLoader firstDomainClassLoader = factory.create(null, this.containerClassLoader, (ArtifactDescriptor)descriptor, Collections.emptyList());
        ArtifactClassLoader secondDomainClassLoader = factory.create(null, this.containerClassLoader, (ArtifactDescriptor)descriptor, Collections.emptyList());
        Assert.assertThat((Object)secondDomainClassLoader, (Matcher)CoreMatchers.is((Object)firstDomainClassLoader));
    }

    @Test
    public void secondClassLoaderCreationDoesntReturnDisposedInstance() {
        String domainName = "custom-domain";
        DomainDescriptor descriptor = this.getTestDescriptor("custom-domain");
        descriptor.setRootFolder(this.createDomainDir("domains", "custom-domain"));
        DeployableArtifactClassLoaderFactory factory = DeployableArtifactClassLoaderFactoryProvider.domainClassLoaderFactory(name -> MuleFoldersUtil.getAppDataFolder((String)name));
        ArtifactClassLoader firstDomainClassLoader = factory.create(null, this.containerClassLoader, (ArtifactDescriptor)descriptor, Collections.emptyList());
        firstDomainClassLoader.dispose();
        ArtifactClassLoader secondDomainClassLoader = factory.create(null, this.containerClassLoader, (ArtifactDescriptor)descriptor, Collections.emptyList());
        Assert.assertThat((Object)secondDomainClassLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)firstDomainClassLoader)));
    }

    @Test
    public void severalCreationsReturnCachedInstancesWhenNotDisposed() {
        String domainName = "custom-domain";
        DomainDescriptor descriptor = this.getTestDescriptor("custom-domain");
        descriptor.setRootFolder(this.createDomainDir("domains", "custom-domain"));
        DeployableArtifactClassLoaderFactory factory = DeployableArtifactClassLoaderFactoryProvider.domainClassLoaderFactory(name -> MuleFoldersUtil.getAppDataFolder((String)name));
        ArtifactClassLoader firstDomainClassLoader = factory.create(null, this.containerClassLoader, (ArtifactDescriptor)descriptor, Collections.emptyList());
        Assert.assertThat((Object)factory.create(null, this.containerClassLoader, (ArtifactDescriptor)descriptor, Collections.emptyList()), (Matcher)CoreMatchers.is((Object)firstDomainClassLoader));
        Assert.assertThat((Object)factory.create(null, this.containerClassLoader, (ArtifactDescriptor)descriptor, Collections.emptyList()), (Matcher)CoreMatchers.is((Object)firstDomainClassLoader));
        firstDomainClassLoader.dispose();
        ArtifactClassLoader secondDomainClassLoader = factory.create(null, this.containerClassLoader, (ArtifactDescriptor)descriptor, Collections.emptyList());
        Assert.assertThat((Object)secondDomainClassLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)firstDomainClassLoader)));
        Assert.assertThat((Object)factory.create(null, this.containerClassLoader, (ArtifactDescriptor)descriptor, Collections.emptyList()), (Matcher)CoreMatchers.is((Object)secondDomainClassLoader));
        Assert.assertThat((Object)factory.create(null, this.containerClassLoader, (ArtifactDescriptor)descriptor, Collections.emptyList()), (Matcher)CoreMatchers.is((Object)secondDomainClassLoader));
    }

    private DomainDescriptor getTestDescriptor(String name) {
        DomainDescriptor descriptor = new DomainDescriptor(name);
        descriptor.setRedeploymentEnabled(false);
        descriptor.setArtifactLocation(this.artifactLocation.getRoot());
        return descriptor;
    }
}

