/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.util.Collection;
import java.util.Collections;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.artifact.api.Artifact;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.internal.ArtifactDeploymentTemplate;
import org.mule.runtime.module.deployment.internal.DefaultArchiveDeployer;

public final class DomainDeploymentTemplate
implements ArtifactDeploymentTemplate {
    private Collection<Application> domainApplications = Collections.emptyList();
    private final DefaultArchiveDeployer<Application> applicationDeployer;
    private final DeploymentService deploymentservice;

    public DomainDeploymentTemplate(DefaultArchiveDeployer<Application> applicationDeployer, DeploymentService deploymentservice) {
        this.applicationDeployer = applicationDeployer;
        this.deploymentservice = deploymentservice;
    }

    @Override
    public void preRedeploy(Artifact domain) {
        if (domain instanceof Domain) {
            this.domainApplications = this.deploymentservice.findDomainApplications(domain.getArtifactName());
            for (Application domainApplication : this.domainApplications) {
                this.applicationDeployer.undeployArtifactWithoutUninstall(domainApplication);
            }
        }
    }

    @Override
    public void postRedeploy(Artifact domain) {
        if (domain != null && !this.domainApplications.isEmpty()) {
            for (Application domainApplication : this.domainApplications) {
                this.applicationDeployer.preTrackArtifact(domainApplication);
                if (!this.applicationDeployer.isUpdatedZombieArtifact(domainApplication.getArtifactName())) continue;
                this.applicationDeployer.deployExplodedArtifact(domainApplication.getArtifactName());
            }
        }
        this.domainApplications = Collections.emptyList();
    }
}

