/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.container.internal.splash.SplashScreen;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.DeploymentStartException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.artifact.api.Artifact;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.MuleContextListenerFactory;
import org.mule.runtime.module.deployment.impl.internal.util.DeploymentPropertiesUtils;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.mule.runtime.module.deployment.internal.ArtifactArchiveInstaller;
import org.mule.runtime.module.deployment.internal.ArtifactDeployer;
import org.mule.runtime.module.deployment.internal.ArtifactDeploymentTemplate;
import org.mule.runtime.module.deployment.internal.NativeLibrariesFolderDeletionActionTask;
import org.mule.runtime.module.deployment.internal.NativeLibrariesFolderDeletionRetryScheduledTask;
import org.mule.runtime.module.deployment.internal.NullDeploymentListener;
import org.mule.runtime.module.deployment.internal.util.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArchiveDeployer<D extends DeployableArtifactDescriptor, T extends DeployableArtifact<D>>
implements ArchiveDeployer<D, T> {
    private static final String FAILED_TO_DEPLOY_ARTIFACT = "Failed to deploy artifact: ";
    public static final String JAR_FILE_SUFFIX = ".jar";
    public static final String ZIP_FILE_SUFFIX = ".zip";
    private static final Logger logger = LoggerFactory.getLogger(DefaultArchiveDeployer.class);
    private static final Logger SPLASH_LOGGER = LoggerFactory.getLogger((String)"org.mule.runtime.core.internal.logging");
    public static final String START_ARTIFACT_ON_DEPLOYMENT_PROPERTY = "startArtifactOnDeployment";
    private static final int CORE_POOL_SIZE = 1;
    private static final int MAX_ATTEMPTS = 6;
    private static final int INITIAL_DELAY = 10;
    private static final int DELAY = 10;
    private final ArtifactDeployer<T> deployer;
    private final ArtifactArchiveInstaller artifactArchiveInstaller;
    private final Map<String, ZombieArtifact> artifactZombieMap = new HashMap<String, ZombieArtifact>();
    private final File artifactDir;
    private final ObservableList<T> artifacts;
    private final ArtifactDeploymentTemplate deploymentTemplate;
    private AbstractDeployableArtifactFactory<D, T> artifactFactory;
    private DeploymentListener deploymentListener = new NullDeploymentListener();
    private final MuleContextListenerFactory muleContextListenerFactory;
    private final Supplier<SchedulerService> artifactStartExecutorSupplier;

    public DefaultArchiveDeployer(ArtifactDeployer<T> deployer, AbstractDeployableArtifactFactory<D, T> artifactFactory, ObservableList<T> artifacts, ArtifactDeploymentTemplate deploymentTemplate, MuleContextListenerFactory muleContextListenerFactory, Supplier<SchedulerService> artifactStartExecutorSupplier) {
        this.deployer = deployer;
        this.artifactFactory = artifactFactory;
        this.artifacts = artifacts;
        this.deploymentTemplate = deploymentTemplate;
        this.artifactDir = artifactFactory.getArtifactDir();
        this.artifactArchiveInstaller = new ArtifactArchiveInstaller(this.artifactDir);
        this.muleContextListenerFactory = muleContextListenerFactory;
        this.artifactStartExecutorSupplier = artifactStartExecutorSupplier;
    }

    @Override
    public boolean isUpdatedZombieArtifact(String artifactName) {
        if (!this.artifactZombieMap.containsKey(artifactName) && this.artifacts.stream().map(Artifact::getArtifactName).anyMatch(deployedAppName -> deployedAppName.equals(artifactName))) {
            return false;
        }
        ZombieArtifact zombieArtifact = this.artifactZombieMap.get(artifactName);
        return zombieArtifact == null || zombieArtifact.updatedZombieApp();
    }

    @Override
    public void undeployArtifact(String artifactId) {
        this.undeployArtifact(artifactId, true);
    }

    protected void undeployArtifact(String artifactId, boolean removeData) {
        ZombieArtifact zombieArtifact = this.artifactZombieMap.get(artifactId);
        if (zombieArtifact != null) {
            if (zombieArtifact.exists()) {
                return;
            }
            this.artifactZombieMap.remove(artifactId);
        }
        T artifact = this.findArtifact(artifactId);
        this.undeploy(artifact, removeData);
    }

    @Override
    public File getDeploymentDirectory() {
        return this.artifactFactory.getArtifactDir();
    }

    private File installArtifact(URI artifactAchivedUri) throws IOException {
        File artifactLocation;
        try {
            artifactLocation = this.installFrom(artifactAchivedUri);
        }
        catch (Throwable t) {
            File artifactArchive = new File(artifactAchivedUri);
            String artifactName = Strings.CI.removeEnd(artifactArchive.getName(), (CharSequence)JAR_FILE_SUFFIX);
            this.logDeploymentFailure(t, artifactName);
            this.addZombieFile(artifactName, artifactArchive);
            this.deploymentListener.onDeploymentFailure(artifactName, t);
            throw t;
        }
        return artifactLocation;
    }

    private void logDeploymentFailure(Throwable t, String artifactName) {
        if (DefaultArchiveDeployer.containsType(t, DeploymentStartException.class)) {
            SPLASH_LOGGER.info(SplashScreen.miniSplash((String)"Failed to deploy artifact: '{}', see artifact's log for details"), (Object)artifactName);
            logger.error(t.getMessage());
        } else {
            SPLASH_LOGGER.info(SplashScreen.miniSplash((String)"Failed to deploy artifact: '{}', see below"), (Object)artifactName);
            logger.error(t.getMessage(), t);
        }
    }

    @Override
    public Map<String, Map<URI, Long>> getArtifactsZombieMap() {
        HashMap<String, Map<URI, Long>> result = new HashMap<String, Map<URI, Long>>();
        for (String artifact : this.artifactZombieMap.keySet()) {
            HashMap<URI, Long> tmpMap = new HashMap<URI, Long>();
            ZombieArtifact zombieArtifact = this.artifactZombieMap.get(artifact);
            for (Map.Entry<File, Long> file : zombieArtifact.initialResourceFiles.entrySet()) {
                tmpMap.put(file.getKey().toURI(), file.getValue());
            }
            result.put(artifact, tmpMap);
        }
        return result;
    }

    @Override
    public void setArtifactFactory(ArtifactFactory<D, T> artifactFactory) {
        if (!(artifactFactory instanceof AbstractDeployableArtifactFactory)) {
            throw new IllegalArgumentException("artifactFactory is expected to be of type " + AbstractDeployableArtifactFactory.class.getName());
        }
        this.artifactFactory = (AbstractDeployableArtifactFactory)artifactFactory;
    }

    @Override
    public void undeployArtifactWithoutUninstall(T artifact) {
        this.logRequestToUndeployArtifact(artifact);
        try {
            this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
            this.deployer.undeploy(artifact);
            this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
        }
        catch (DeploymentException e) {
            this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), e);
            throw e;
        }
    }

    ArtifactDeployer getDeployer() {
        return this.deployer;
    }

    @Override
    public void setDeploymentListener(DeploymentListener deploymentListener) {
        this.deploymentListener = deploymentListener;
    }

    private T doDeployExplodedArtifact(String addedArtifact, Optional<Properties> deploymentProperties, Optional<Properties> artifactStatusProperties) throws DeploymentException {
        T artifact;
        logger.debug("================== New Exploded Artifact: {}", (Object)addedArtifact);
        try {
            File artifactLocation = new File(this.artifactDir, addedArtifact);
            artifact = this.createArtifact(artifactLocation, deploymentProperties);
            this.trackArtifact(artifact);
        }
        catch (Throwable t) {
            this.addZombieFile(addedArtifact, new File(this.artifactDir, addedArtifact));
            this.logDeploymentFailure(t, addedArtifact);
            this.deploymentListener.onDeploymentFailure(addedArtifact, t);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)(FAILED_TO_DEPLOY_ARTIFACT + addedArtifact)), t);
        }
        this.deployArtifact(artifact, deploymentProperties, artifactStatusProperties);
        return artifact;
    }

    private void addZombieApp(DeployableArtifact artifact) {
        if (DefaultArchiveDeployer.allResourcesExist(artifact.getResourceFiles())) {
            try {
                ArrayList<File> resourceFiles = new ArrayList<File>();
                resourceFiles.addAll(Arrays.asList(artifact.getResourceFiles()));
                if (artifact.getDescriptor().isRedeploymentEnabled()) {
                    resourceFiles.add(artifact.getDescriptor().getDescriptorFile());
                }
                this.artifactZombieMap.put(artifact.getArtifactName(), new ZombieArtifact(resourceFiles.toArray(new File[resourceFiles.size()])));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addZombieFile(String artifactName, File marker) {
        if (marker == null) {
            return;
        }
        if (!marker.exists()) {
            return;
        }
        try {
            this.artifactZombieMap.put(artifactName, new ZombieArtifact(new File[]{marker}));
        }
        catch (Exception e) {
            logger.debug(String.format("Failed to mark an exploded artifact [%s] as a zombie", marker.getName()), (Throwable)e);
        }
    }

    private T findArtifact(String artifactName) {
        return (T)((DeployableArtifact)this.artifacts.stream().filter(artifact -> artifact.getArtifactName().equals(artifactName)).findAny().orElse(null));
    }

    private void trackArtifact(T artifact) {
        this.preTrackArtifact(artifact);
        this.artifacts.add(artifact);
    }

    public void preTrackArtifact(T artifact) {
        T previousArtifact = this.findArtifact(artifact.getArtifactName());
        this.artifacts.remove(previousArtifact);
    }

    private void undeploy(T artifact, boolean removeData) {
        this.logRequestToUndeployArtifact(artifact);
        try {
            this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
            this.artifacts.remove(artifact);
            this.deployer.undeploy(artifact);
            this.artifactArchiveInstaller.uninstallArtifact(artifact.getArtifactName());
            File dataFolder = MuleFoldersUtil.getAppDataFolder((String)artifact.getDescriptor().getDataFolderName());
            try {
                if (removeData) {
                    FileUtils.deleteDirectory((File)dataFolder);
                }
                this.deleteNativeLibraries(artifact);
            }
            catch (IOException e) {
                logger.warn(String.format("Cannot delete data folder '%s' while undeploying artifact '%s'. This could be related to some files still being used and can cause a memory leak", dataFolder, artifact.getArtifactName()), (Throwable)e);
            }
            this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
            this.logArtifactUndeployed(artifact);
        }
        catch (RuntimeException e) {
            this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), e);
            throw e;
        }
    }

    private void deleteNativeLibraries(T artifact) {
        String loadedNativeLibrariesFolderName;
        String appDataFolderName = artifact.getDescriptor().getDataFolderName();
        File appNativeLibrariesFolder = MuleFoldersUtil.getAppNativeLibrariesTempFolder((String)appDataFolderName, (String)(loadedNativeLibrariesFolderName = artifact.getDescriptor().getLoadedNativeLibrariesFolderName()));
        if (appNativeLibrariesFolder.exists()) {
            try {
                FileUtils.deleteDirectory((File)appNativeLibrariesFolder);
                logger.debug("App Native Libraries folder deleted: {}", (Object)appNativeLibrariesFolder.getAbsolutePath());
            }
            catch (IOException e) {
                logger.debug(String.format("Cannot delete native libraries data folder '%s' while undeploying artifact '%s'. This could be related to some files still being used. Scheduling a task to removed them.", appNativeLibrariesFolder, artifact.getArtifactName()), (Throwable)e);
                this.executeSchedulerFileDeletion(artifact);
            }
        }
    }

    private void executeSchedulerFileDeletion(T artifact) {
        String appDataFolderName = artifact.getDescriptor().getDataFolderName();
        String loadedNativeLibrariesFolderName = artifact.getDescriptor().getLoadedNativeLibrariesFolderName();
        File appNativeLibrariesFolder = MuleFoldersUtil.getAppNativeLibrariesTempFolder((String)appDataFolderName, (String)loadedNativeLibrariesFolderName);
        Scheduler scheduler = this.artifactStartExecutorSupplier.get().customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1).withName("RetryScheduledFolderDeletionTask-StaleCleaner"));
        NativeLibrariesFolderDeletionRetryScheduledTask retryTask = new NativeLibrariesFolderDeletionRetryScheduledTask((ScheduledExecutorService)scheduler, 6, new NativeLibrariesFolderDeletionActionTask(appDataFolderName, appNativeLibrariesFolder));
        scheduler.scheduleWithFixedDelay((Runnable)retryTask, 10L, 10L, TimeUnit.SECONDS);
    }

    private void logRequestToUndeployArtifact(T artifact) {
        logger.info("================== Request to Undeploy Artifact: {}", (Object)artifact.getArtifactName());
    }

    private void logArtifactUndeployed(T artifact) {
        SPLASH_LOGGER.info(SplashScreen.miniSplash((String)String.format("Undeployed artifact '%s'", artifact.getArtifactName())));
    }

    private File installFrom(URI uri) throws IOException {
        return this.artifactArchiveInstaller.installArtifact(uri);
    }

    private T createArtifact(File artifactLocation, Optional<Properties> appProperties) throws IOException {
        DeployableArtifact artifact = this.artifactFactory.createArtifact(artifactLocation, appProperties);
        artifact.setMuleContextListener(this.muleContextListenerFactory.create(artifact.getArtifactName()));
        return (T)artifact;
    }

    private static boolean allResourcesExist(File[] resourceFiles) {
        return Arrays.stream(resourceFiles).allMatch(File::exists);
    }

    @Override
    public T deployPackagedArtifact(String zip, Optional<Properties> deploymentProperties) throws DeploymentException {
        try {
            String str = zip;
            String artifactName = Strings.CI.removeEnd(str, (CharSequence)JAR_FILE_SUFFIX);
            File artifactZip = new File(this.artifactDir, zip);
            URI uri = artifactZip.toURI();
            return this.deployOrRedeployPackagedArtifact(uri, artifactName, deploymentProperties);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)("Failed to deploy from zip: " + zip)), (Throwable)e);
        }
    }

    @Override
    public T deployPackagedArtifact(URI artifactAchivedUri, Optional<Properties> appProperties) throws DeploymentException {
        String artifactName = Strings.CI.removeEnd(new File(artifactAchivedUri).getName(), (CharSequence)JAR_FILE_SUFFIX);
        return this.deployOrRedeployPackagedArtifact(artifactAchivedUri, artifactName, appProperties);
    }

    @Override
    public void redeploy(String artifactName, Optional<Properties> deploymentProperties) throws DeploymentException {
        SPLASH_LOGGER.info(SplashScreen.miniSplash((String)String.format("Redeploying artifact '%s'", artifactName)));
        T artifact = this.findArtifact(artifactName);
        File artifactLocation = artifact.getLocation();
        DeployableArtifactDescriptor artifactDescriptor = artifact.getDescriptor();
        this.deploymentListener.onRedeploymentStart(artifactName);
        this.deploymentTemplate.preRedeploy((Artifact)artifact);
        if (!this.artifactZombieMap.containsKey(artifactName)) {
            this.deploymentListener.onUndeploymentStart(artifactName);
            try {
                this.deployer.undeploy(artifact);
                this.deleteNativeLibraries(artifact);
                artifact = null;
                this.deploymentListener.onUndeploymentSuccess(artifactName);
            }
            catch (Throwable e) {
                this.deploymentListener.onUndeploymentFailure(artifactName, e);
                this.deploymentListener.onRedeploymentFailure(artifactName, e);
            }
        }
        this.deploymentListener.onDeploymentStart(artifactName);
        try {
            artifact = this.createArtifact(artifactLocation, Optional.ofNullable(DeploymentPropertiesUtils.resolveDeploymentProperties((String)artifactDescriptor.getDataFolderName(), deploymentProperties)));
        }
        catch (IOException t) {
            try {
                this.logDeploymentFailure(t, artifactName);
                String msg = FAILED_TO_DEPLOY_ARTIFACT + artifactName;
                throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)msg), (Throwable)t);
            }
            catch (Throwable throwable) {
                this.deploymentListener.onDeploymentFailure(artifactName, t);
                this.deploymentListener.onRedeploymentFailure(artifactName, t);
                throw throwable;
            }
        }
        try {
            this.trackArtifact(artifact);
            this.deployer.deploy(artifact);
            this.artifactArchiveInstaller.createAnchorFile(artifact.getArtifactName());
            this.deploymentListener.onDeploymentSuccess(artifact.getArtifactName());
            this.deploymentTemplate.postRedeploy((Artifact)artifact);
            this.deploymentListener.onRedeploymentSuccess(artifact.getArtifactName());
        }
        catch (Throwable t) {
            try {
                this.logDeploymentFailure(t, artifact.getArtifactName());
                this.addZombieApp((DeployableArtifact)artifact);
                if (t instanceof DeploymentException) {
                    throw (DeploymentException)t;
                }
                String msg = FAILED_TO_DEPLOY_ARTIFACT + artifact.getArtifactName();
                throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)msg), t);
            }
            catch (Throwable throwable) {
                this.deploymentListener.onDeploymentFailure(artifact.getArtifactName(), t);
                this.deploymentListener.onRedeploymentFailure(artifact.getArtifactName(), t);
                throw throwable;
            }
        }
        this.artifactZombieMap.remove(artifact.getArtifactName());
    }

    @Override
    public void deployArtifact(T artifact, Optional<Properties> deploymentProperties) throws DeploymentException {
        this.deployArtifact(artifact, deploymentProperties, Optional.empty());
    }

    public void deployArtifact(T artifact, Optional<Properties> deploymentProperties, Optional<Properties> artifactStatusProperties) throws DeploymentException {
        try {
            this.trackArtifact(artifact);
            this.deploymentListener.onDeploymentStart(artifact.getArtifactName());
            this.deployer.deploy(artifact, this.shouldStartArtifactAccordingToStatusBeforeDomainRedeployment(artifact, artifactStatusProperties.orElse(null)));
            this.artifactArchiveInstaller.createAnchorFile(artifact.getArtifactName());
            this.deploymentListener.onDeploymentSuccess(artifact.getArtifactName());
            this.artifactZombieMap.remove(artifact.getArtifactName());
        }
        catch (Throwable t) {
            this.logDeploymentFailure(t, artifact.getArtifactName());
            this.addZombieApp((DeployableArtifact)artifact);
            this.deploymentListener.onDeploymentFailure(artifact.getArtifactName(), t);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)(FAILED_TO_DEPLOY_ARTIFACT + artifact.getArtifactName())), t);
        }
    }

    public static boolean containsType(Throwable throwable, Class<? extends Throwable> type) {
        return ExceptionUtils.indexOfType((Throwable)throwable, type) > -1;
    }

    private boolean shouldStartArtifactAccordingToStatusBeforeDomainRedeployment(T artifact, Properties artifactStatusProperties) {
        if (!(artifact instanceof Application) || artifactStatusProperties == null) {
            return true;
        }
        return Boolean.valueOf(artifactStatusProperties.getProperty(START_ARTIFACT_ON_DEPLOYMENT_PROPERTY, "true"));
    }

    private T deployOrRedeployPackagedArtifact(URI artifactUri, String artifactName, Optional<Properties> deploymentProperties) {
        ZombieArtifact zombieArtifact = this.artifactZombieMap.get(artifactName);
        if (zombieArtifact != null && zombieArtifact.isFor(artifactUri) && !zombieArtifact.updatedZombieApp()) {
            return null;
        }
        T artifact = this.findArtifact(artifactName);
        boolean isRedeploy = artifact != null;
        try {
            if (isRedeploy) {
                this.deploymentListener.onRedeploymentStart(artifactName);
                this.deploymentTemplate.preRedeploy((Artifact)artifact);
                artifact = null;
                this.undeployArtifact(artifactName, false);
            }
            T deployedArtifact = this.internalDeployPackagedArtifact(artifactUri, deploymentProperties);
            if (isRedeploy) {
                this.deploymentTemplate.postRedeploy((Artifact)deployedArtifact);
                this.deploymentListener.onRedeploymentSuccess(artifactName);
            }
            return deployedArtifact;
        }
        catch (RuntimeException e) {
            if (isRedeploy) {
                this.deploymentListener.onRedeploymentFailure(artifactName, e);
            }
            throw e;
        }
    }

    private T internalDeployPackagedArtifact(URI artifactAchivedUri, Optional<Properties> appProperties) throws DeploymentException {
        try {
            T artifact;
            File artifactLocation = this.installArtifact(artifactAchivedUri);
            try {
                artifact = this.createArtifact(artifactLocation, appProperties);
                this.trackArtifact(artifact);
            }
            catch (Throwable t) {
                String artifactName = artifactLocation.getName();
                this.logDeploymentFailure(t, artifactName);
                this.addZombieFile(artifactName, artifactLocation);
                this.deploymentListener.onDeploymentFailure(artifactName, t);
                throw t;
            }
            this.deployArtifact(artifact, appProperties);
            return artifact;
        }
        catch (Throwable t) {
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            String msg = "Failed to deploy from URI: " + String.valueOf(artifactAchivedUri);
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)msg), t);
        }
    }

    @Override
    public T deployExplodedArtifact(String artifactDir, Optional<Properties> deploymentProperties) {
        return this.deployExplodedArtifact(artifactDir, deploymentProperties, Optional.empty());
    }

    public T deployExplodedArtifact(String artifactDir, Optional<Properties> deploymentProperties, Optional<Properties> artifactStatusProperties) {
        if (!this.isUpdatedZombieArtifact(artifactDir)) {
            return null;
        }
        return this.doDeployExplodedArtifact(artifactDir, deploymentProperties, artifactStatusProperties);
    }

    @Override
    public void doNotPersistArtifactStop(T artifact) {
        this.deployer.doNotPersistArtifactStop(artifact);
    }

    public AbstractDeployableArtifactFactory<D, T> getArtifactFactory() {
        return this.artifactFactory;
    }

    private static class ZombieArtifact {
        Map<File, Long> initialResourceFiles = new HashMap<File, Long>();

        private ZombieArtifact(File[] resourceFiles) {
            for (File resourceFile : resourceFiles) {
                this.initialResourceFiles.put(resourceFile, resourceFile.lastModified());
            }
        }

        public boolean isFor(URI uri) {
            return this.initialResourceFiles.entrySet().stream().anyMatch(entry -> ((File)entry.getKey()).toURI().equals(uri));
        }

        public boolean updatedZombieApp() {
            return this.initialResourceFiles.entrySet().stream().anyMatch(entry -> !((Long)entry.getValue()).equals(((File)entry.getKey()).lastModified()));
        }

        public boolean exists() {
            return DefaultArchiveDeployer.allResourcesExist(this.initialResourceFiles.keySet().toArray(new File[this.initialResourceFiles.size()]));
        }
    }
}

