/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.deployment.test.internal;

import static org.mule.runtime.module.deployment.test.internal.artifacts.TestArtifactsCatalog.byeXmlExtensionPlugin;
import static org.mule.test.allure.AllureConstants.LeakPrevention.LEAK_PREVENTION;
import static org.mule.test.allure.AllureConstants.LeakPrevention.LeakPreventionMetaspace.METASPACE_LEAK_PREVENTION_ON_REDEPLOY;

import static java.util.Collections.singleton;

import org.mule.runtime.extension.internal.loader.xml.XmlExtensionLoaderDelegate;
import org.mule.runtime.module.deployment.impl.internal.builder.ArtifactPluginFileBuilder;

import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;

import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;

@Feature(LEAK_PREVENTION)
@Story(METASPACE_LEAK_PREVENTION_ON_REDEPLOY)
@Issue("W-16814280")
public class XmlPluginClassLoaderLeakOnDeploymentTestCase extends ClassLoaderLeakTestCase {

  @BeforeAll
  public static void before() {
    XmlExtensionLoaderDelegate.forceTransformerPoolRecreation(true);
  }

  @AfterAll
  public static void after() {
    XmlExtensionLoaderDelegate.forceTransformerPoolRecreation(false);
  }

  public static final Supplier<Set<ArtifactPluginFileBuilder>> XML_SDK_PLUGIN = () -> singleton(byeXmlExtensionPlugin);

  static Stream<Arguments> parameters() {
    return Stream.of(
                     Arguments.of("appWithExtensionPlugin-1.0.0-mule-application",
                                  "app-with-extension-xml-plugin-module-bye",
                                  XML_SDK_PLUGIN));
  }

  @ParameterizedTest(name = "{displayName} AppName: {0}")
  @MethodSource("parameters")
  @Override
  protected void undeploysApplicationDoesNotLeakClassloader(String appName, String xmlFile,
                                                            Supplier<Set<ArtifactPluginFileBuilder>> applicationPlugins)
      throws Exception {
    super.undeploysApplicationDoesNotLeakClassloader(appName, xmlFile, applicationPlugins);
  }

  @ParameterizedTest(name = "{displayName} AppName: {0}")
  @MethodSource("parameters")
  @Override
  protected void undeploysApplicationWithPoliciesDoesNotLeakClassloader(String appName, String xmlFile,
                                                                        Supplier<Set<ArtifactPluginFileBuilder>> applicationPlugins)
      throws Exception {
    super.undeploysApplicationWithPoliciesDoesNotLeakClassloader(appName, xmlFile, applicationPlugins);
  }

  @ParameterizedTest(name = "{displayName} AppName: {0}")
  @MethodSource("parameters")
  @Override
  protected void undeploysApplicationWithTracingDoesNotLeakClassloader(String appName, String xmlFile,
                                                                       Supplier<Set<ArtifactPluginFileBuilder>> applicationPlugins)
      throws Exception {
    super.undeploysApplicationWithTracingDoesNotLeakClassloader(appName, xmlFile, applicationPlugins);
  }

  @ParameterizedTest(name = "{displayName} AppName: {0}")
  @MethodSource("parameters")
  @Override
  protected void redeployByConfigChangePreviousAppEagerlyGCd(String appName, String xmlFile,
                                                             Supplier<Set<ArtifactPluginFileBuilder>> applicationPlugins)
      throws Exception {
    super.redeployByConfigChangePreviousAppEagerlyGCd(appName, xmlFile, applicationPlugins);
  }

  @ParameterizedTest(name = "{displayName} AppName: {0}")
  @MethodSource("parameters")
  @Override
  protected void redeployPreviousAppEagerlyGCd(String appName, String xmlFile,
                                               Supplier<Set<ArtifactPluginFileBuilder>> applicationPlugins)
      throws Exception {
    super.redeployByConfigChangePreviousAppEagerlyGCd(appName, xmlFile, applicationPlugins);
  }

  @ParameterizedTest(name = "{displayName} AppName: {0}")
  @MethodSource("parameters")
  @Override
  protected void redeployByNamePreviousAppEagerlyGCd(String appName, String xmlFile,
                                                     Supplier<Set<ArtifactPluginFileBuilder>> applicationPlugins)
      throws Exception {
    super.redeployByConfigChangePreviousAppEagerlyGCd(appName, xmlFile, applicationPlugins);
  }

}
