/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.deployment.test.internal.util;

import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;
import static org.mule.runtime.module.deployment.internal.processor.SerializedAstArtifactConfigurationProcessor.serializedAstWithFallbackArtifactConfigurationProcessor;

import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContextConfiguration;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;


public class FailOnConditionArtifactConfigurationProcessor implements ArtifactConfigurationProcessor {

  private static final ConfigurationException EXPECTED = new ConfigurationException(createStaticMessage("Expected"));

  private List<Predicate<ArtifactContextConfiguration>> failDeploymentPredicates = new ArrayList<>();

  @Override
  public ArtifactContext createArtifactContext(ArtifactContextConfiguration artifactContextConfiguration)
      throws ConfigurationException {
    if (!failDeploymentPredicates.isEmpty()
        && failDeploymentPredicates.stream().anyMatch(p -> p.test(artifactContextConfiguration))) {
      throw EXPECTED;
    } else {
      return serializedAstWithFallbackArtifactConfigurationProcessor().createArtifactContext(artifactContextConfiguration);
    }
  }

  public void expectedFailure(Predicate<ArtifactContextConfiguration> failDeploymentPredicate) {
    this.failDeploymentPredicates.add(failDeploymentPredicate);
  }

  public void clearExpectedFailures() {
    this.failDeploymentPredicates.clear();
  }

}
