/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component.config;

import com.google.common.collect.ImmutableList;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;

@NoExtend
public class DefaultComponentLocation
implements ComponentLocation,
Serializable {
    private static final long serialVersionUID = 4958158607813720623L;
    private String name;
    private LinkedList<DefaultLocationPart> parts;
    private volatile String location;
    private transient TypedComponentIdentifier componentIdentifier;

    public static DefaultComponentLocation fromSingleComponent(String component) {
        DefaultLocationPart part = new DefaultLocationPart(component, Optional.of(TypedComponentIdentifier.builder().type(TypedComponentIdentifier.ComponentType.UNKNOWN).identifier(ComponentIdentifier.buildFromStringRepresentation((String)component)).build()), Optional.empty(), Optional.empty(), Optional.empty());
        return new DefaultComponentLocation(Optional.of(component), Arrays.asList(part));
    }

    public DefaultComponentLocation(Optional<String> name, List<DefaultLocationPart> parts) {
        this.name = name.orElse(null);
        this.parts = new LinkedList<DefaultLocationPart>(parts);
        this.componentIdentifier = this.calculateComponentIdentifier(parts);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public List<LocationPart> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    public TypedComponentIdentifier getComponentIdentifier() {
        if (this.componentIdentifier == null) {
            throw new NoSuchElementException();
        }
        return this.componentIdentifier;
    }

    public Optional<String> getFileName() {
        return this.parts.getLast().getFileName();
    }

    public Optional<Integer> getLineInFile() {
        return this.parts.getLast().getLineInFile();
    }

    public Optional<Integer> getStartColumn() {
        return this.parts.getLast().getStartColumn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocation() {
        if (this.location == null) {
            DefaultComponentLocation defaultComponentLocation = this;
            synchronized (defaultComponentLocation) {
                if (this.location == null) {
                    StringBuilder locationBuilder = new StringBuilder();
                    for (DefaultLocationPart part : this.parts) {
                        locationBuilder.append("/").append(part.getPartPath());
                    }
                    this.location = locationBuilder.replace(0, 1, "").toString();
                }
            }
        }
        return this.location;
    }

    public String getRootContainerName() {
        return this.getParts().get(0).getPartPath();
    }

    public DefaultComponentLocation appendLocationPart(String partPath, Optional<TypedComponentIdentifier> partIdentifier, Optional<String> fileName, Optional<Integer> lineInFile, Optional<Integer> startColumn) {
        return new DefaultComponentLocation(Optional.ofNullable(this.name), (List<DefaultLocationPart>)ImmutableList.builder().addAll(this.parts).add((Object)new DefaultLocationPart(partPath, partIdentifier, fileName, lineInFile, startColumn)).build());
    }

    public DefaultComponentLocation appendProcessorsPart() {
        return new DefaultComponentLocation(Optional.ofNullable(this.name), (List<DefaultLocationPart>)ImmutableList.builder().addAll(this.parts).add((Object)new DefaultLocationPart("processors", Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).build());
    }

    public DefaultComponentLocation appendRoutePart() {
        return new DefaultComponentLocation(Optional.ofNullable(this.name), (List<DefaultLocationPart>)ImmutableList.builder().addAll(this.parts).add((Object)new DefaultLocationPart("route", Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).build());
    }

    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        this.componentIdentifier = this.calculateComponentIdentifier(this.parts);
    }

    private TypedComponentIdentifier calculateComponentIdentifier(List<DefaultLocationPart> parts) {
        return parts.isEmpty() ? null : (TypedComponentIdentifier)parts.get(parts.size() - 1).getPartIdentifier().orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultComponentLocation that = (DefaultComponentLocation)o;
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (!this.getParts().equals(that.getParts())) {
            return false;
        }
        return this.getLocation() != null ? this.getLocation().equals(that.getLocation()) : that.getLocation() == null;
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        result = 31 * result + this.getParts().hashCode();
        result = 31 * result + (this.getLocation() != null ? this.getLocation().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultComponentLocation{name='" + this.name + '\'' + ", parts=" + this.parts + ", location='" + this.getLocation() + '\'' + '}';
    }

    @NoInstantiate
    @NoExtend
    public static class DefaultLocationPart
    implements LocationPart,
    Serializable {
        private static final long serialVersionUID = 5757545892752260058L;
        private String partPath;
        private TypedComponentIdentifier partIdentifier;
        private String fileName;
        private Integer lineInFile;
        private Integer startColumn;

        public DefaultLocationPart(String partPath, Optional<TypedComponentIdentifier> partIdentifier, Optional<String> fileName, Optional<Integer> lineInFile, Optional<Integer> startColumn) {
            this.partPath = partPath;
            this.partIdentifier = partIdentifier.orElse(null);
            fileName.ifPresent(configFileName -> {
                this.fileName = configFileName;
            });
            lineInFile.ifPresent(line -> {
                this.lineInFile = line;
            });
            startColumn.ifPresent(column -> {
                this.startColumn = column;
            });
        }

        public String getPartPath() {
            return this.partPath;
        }

        public Optional<TypedComponentIdentifier> getPartIdentifier() {
            return Optional.ofNullable(this.partIdentifier);
        }

        public Optional<String> getFileName() {
            return Optional.ofNullable(this.fileName);
        }

        public Optional<Integer> getLineInFile() {
            return Optional.ofNullable(this.lineInFile);
        }

        public Optional<Integer> getStartColumn() {
            return Optional.ofNullable(this.startColumn);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultLocationPart that = (DefaultLocationPart)o;
            if (!Objects.equals(this.getPartPath(), that.getPartPath())) {
                return false;
            }
            if (this.getPartIdentifier() != null ? !this.getPartIdentifier().equals(that.getPartIdentifier()) : that.getPartIdentifier() != null) {
                return false;
            }
            if (this.getFileName() != null ? !this.getFileName().equals(that.getFileName()) : that.getFileName() != null) {
                return false;
            }
            if (this.getStartColumn() != null ? !this.getStartColumn().equals(that.getStartColumn()) : that.getStartColumn() != null) {
                return false;
            }
            return this.getLineInFile() != null ? this.getLineInFile().equals(that.getLineInFile()) : that.getLineInFile() == null;
        }

        public int hashCode() {
            int result = this.getPartPath() != null ? this.getPartPath().hashCode() : 31;
            result = 31 * result + (this.getPartIdentifier() != null ? this.getPartIdentifier().hashCode() : 0);
            result = 31 * result + (this.getFileName() != null ? this.getFileName().hashCode() : 0);
            result = 31 * result + (this.getLineInFile() != null ? this.getLineInFile().hashCode() : 0);
            result = 31 * result + (this.getStartColumn() != null ? this.getStartColumn().hashCode() : 0);
            return result;
        }

        public String toString() {
            return "DefaultLocationPart{partPath='" + this.partPath + '\'' + ", partIdentifier=" + this.partIdentifier + ", fileName='" + this.fileName + '\'' + ", lineInFile=" + this.lineInFile + ", startColumn=" + this.startColumn + '}';
        }
    }
}

