/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xerces.xni.parser;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.apache.xerces.xni.parser.XMLParseException;
import org.mule.runtime.dsl.internal.xerces.xni.parser.DefaultXmlGathererErrorHandler;
import org.mule.runtime.dsl.internal.xerces.xni.parser.XmlGathererErrorHandler;

@Feature(value="Mule DSL Parsing")
@Story(value="XML Grammar Pool")
public class DefaultXmlGathererErrorHandlerTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private XmlGathererErrorHandler errorHandler;

    @Before
    public void setup() {
        this.errorHandler = new DefaultXmlGathererErrorHandler();
    }

    @Test
    public void xmlGathererErrorHandlerShouldGatherErrors() {
        XMLParseException e = new XMLParseException(null, "First fake xml parse exception");
        this.errorHandler.error("domain", "key", e);
        XMLParseException e2 = new XMLParseException(null, "Second fake xml parse exception");
        this.errorHandler.error("domain", "key", e2);
        MatcherAssert.assertThat((Object)this.errorHandler.getErrors().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((XMLParseException)this.errorHandler.getErrors().get(0)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
        MatcherAssert.assertThat((Object)((XMLParseException)this.errorHandler.getErrors().get(1)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e2)));
    }

    @Test
    public void xmlGathererErrorHandlerShouldNotGatherWarning() {
        XMLParseException exception = new XMLParseException(null, "Fake xml parse exception");
        this.errorHandler.warning("domain", "key", exception);
        MatcherAssert.assertThat((Object)this.errorHandler.getErrors().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void xmlGathererErrorHandlerShouldFailOnFatalError() {
        this.thrown.expect(XMLParseException.class);
        XMLParseException exception = new XMLParseException(null, "Fake xml parse exception");
        this.errorHandler.fatalError("domain", "key", exception);
    }
}

