/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xerces.xni.parser;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.apache.xerces.impl.xs.XSDDescription;
import org.mule.apache.xerces.xni.XMLResourceIdentifier;
import org.mule.apache.xerces.xni.parser.XMLInputSource;
import org.mule.runtime.dsl.internal.xerces.xni.parser.DefaultXmlEntityResolver;

@Feature(value="Mule DSL Parsing")
@Story(value="XML Grammar Pool")
public class DefaultXmlEntityResolverTestCase {
    private static final String INVALID_XSD = "http://www.mulesoft.org/schema/mule/core/current/mule-invalid.xsd";
    private static final String INVALID_TARGET_XSD = "http://www.mulesoft.org/schema/mule/core/current/mule-invalid-target.xsd";
    private static final String COMPANY_XSD = "http://www.mulesoft.org/schema/mule/fake-company/current/company.xsd";
    private DefaultXmlEntityResolver entityResolver;

    @Before
    public void setup() {
        this.entityResolver = new DefaultXmlEntityResolver();
    }

    @Test
    public void emptyXSDDescriptionShouldReturnNullSource() throws Exception {
        XSDDescription resourceIdentifier = new XSDDescription();
        resourceIdentifier.setPublicId(null);
        resourceIdentifier.setExpandedSystemId(null);
        XMLInputSource source = this.entityResolver.resolveEntity((XMLResourceIdentifier)resourceIdentifier);
        MatcherAssert.assertThat((Object)source, (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void invalidSchemaMappingsShouldReturnNullSource() throws Exception {
        XSDDescription resourceIdentifier = new XSDDescription();
        resourceIdentifier.setPublicId(null);
        resourceIdentifier.setExpandedSystemId(INVALID_XSD);
        XMLInputSource source = this.entityResolver.resolveEntity((XMLResourceIdentifier)resourceIdentifier);
        MatcherAssert.assertThat((Object)source, (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void existingSchemaMappingsShouldReturnValidSource() throws Exception {
        XSDDescription resourceIdentifier = new XSDDescription();
        resourceIdentifier.setPublicId(null);
        resourceIdentifier.setExpandedSystemId(COMPANY_XSD);
        XMLInputSource is = this.entityResolver.resolveEntity((XMLResourceIdentifier)resourceIdentifier);
        MatcherAssert.assertThat((Object)is, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)is.getPublicId(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)is.getSystemId(), (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)is.getBaseSystemId(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)is.getByteStream(), (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void existingSchemaMappingsWithInvalidResourceShouldReturnNulSource() throws Exception {
        XSDDescription resourceIdentifier = new XSDDescription();
        resourceIdentifier.setPublicId(null);
        resourceIdentifier.setExpandedSystemId(INVALID_TARGET_XSD);
        XMLInputSource is = this.entityResolver.resolveEntity((XMLResourceIdentifier)resourceIdentifier);
        MatcherAssert.assertThat((Object)is, (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
    }
}

