/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xerces.xni.parser;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.apache.xerces.xni.grammars.Grammar;
import org.mule.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.mule.apache.xerces.xni.grammars.XMLGrammarPool;
import org.mule.runtime.dsl.internal.xerces.xni.parser.ReadOnlyXmlGrammarPool;

@Feature(value="Mule DSL Parsing")
@Story(value="XML Grammar Pool")
public class ReadOnlyXmlGrammarPoolTestCase {
    private XMLGrammarPool core;
    private ReadOnlyXmlGrammarPool readOnlyXmlGrammarPool;

    @Before
    public void setup() {
        this.core = (XMLGrammarPool)Mockito.mock(XMLGrammarPool.class);
        Mockito.when((Object)this.core.retrieveInitialGrammarSet((String)ArgumentMatchers.eq((Object)"http://www.w3.org/2001/XMLSchema"))).thenReturn((Object)new Grammar[]{(Grammar)Mockito.mock(Grammar.class)});
        Mockito.when((Object)this.core.retrieveInitialGrammarSet((String)ArgumentMatchers.eq((Object)"http://www.w3.org/TR/REC-xml"))).thenReturn((Object)new Grammar[0]);
        this.readOnlyXmlGrammarPool = new ReadOnlyXmlGrammarPool(this.core);
    }

    @Test
    public void readOnlyXmlGrammarPoolShouldContainsOnlyPreloadGrammars() {
        Grammar[] grammars = new Grammar[]{(Grammar)Mockito.mock(Grammar.class)};
        this.readOnlyXmlGrammarPool.cacheGrammars("http://www.w3.org/2001/XMLSchema", grammars);
        this.readOnlyXmlGrammarPool.cacheGrammars("http://www.w3.org/TR/REC-xml", grammars);
        ((XMLGrammarPool)Mockito.verify((Object)this.core, (VerificationMode)Mockito.never())).cacheGrammars(ArgumentMatchers.anyString(), (Grammar[])ArgumentMatchers.any());
        grammars = this.readOnlyXmlGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
        MatcherAssert.assertThat((Object)grammars.length, (Matcher)CoreMatchers.is((Object)1));
        ((XMLGrammarPool)Mockito.verify((Object)this.core)).retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
        grammars = this.readOnlyXmlGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/TR/REC-xml");
        MatcherAssert.assertThat((Object)grammars.length, (Matcher)CoreMatchers.is((Object)0));
        ((XMLGrammarPool)Mockito.verify((Object)this.core)).retrieveInitialGrammarSet("http://www.w3.org/TR/REC-xml");
    }

    @Test
    public void readOnlyXmlGrammarPoolUseCorePoolToRetrieveGrammars() {
        XMLGrammarDescription description = (XMLGrammarDescription)Mockito.mock(XMLGrammarDescription.class);
        this.readOnlyXmlGrammarPool.retrieveGrammar(description);
        ((XMLGrammarPool)Mockito.verify((Object)this.core)).retrieveGrammar(description);
    }

    @Test
    public void readOnlyXmlGrammarPoolNotAllowLockOrUnlockPool() {
        this.readOnlyXmlGrammarPool.lockPool();
        ((XMLGrammarPool)Mockito.verify((Object)this.core, (VerificationMode)Mockito.never())).lockPool();
        this.readOnlyXmlGrammarPool.unlockPool();
        ((XMLGrammarPool)Mockito.verify((Object)this.core, (VerificationMode)Mockito.never())).unlockPool();
    }

    @Test
    public void readOnlyXmlGrammarPoolNotAllowClearPool() {
        this.readOnlyXmlGrammarPool.clear();
        ((XMLGrammarPool)Mockito.verify((Object)this.core, (VerificationMode)Mockito.never())).clear();
    }
}

