/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.dsl.api.component;

import static java.util.Collections.unmodifiableSet;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * Simple type values for DSL processing.
 *
 * @since 4.0
 */
public class DslSimpleType {

  public static final String SIMPLE_TYPE_VALUE_PARAMETER_NAME = "value";

  private final static Set<Class<?>> simpleTypes;

  static {
    Set<Class<?>> types = new HashSet<>();
    types.add(Byte.class);
    types.add(byte.class);
    types.add(Short.class);
    types.add(short.class);
    types.add(Integer.class);
    types.add(int.class);
    types.add(Long.class);
    types.add(long.class);
    types.add(Character.class);
    types.add(char.class);
    types.add(Float.class);
    types.add(float.class);
    types.add(Double.class);
    types.add(BigDecimal.class);
    types.add(BigInteger.class);
    types.add(double.class);
    types.add(String.class);
    types.add(Date.class);
    types.add(LocalDate.class);
    types.add(LocalDateTime.class);
    types.add(Calendar.class);
    simpleTypes = unmodifiableSet(types);
  }

  /**
   * @param type the value type.
   * @return true if the type is a primitive type, a primitive type wrapper class, string or an enum.
   */
  public static boolean isSimpleType(Class<?> type) {
    return simpleTypes.contains(type) || type.isEnum();
  }

  private DslSimpleType() {}
}
