/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xml.parser;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.dsl.internal.xml.parser.XmlMetadataAnnotations;

public class DefaultXmlMetadataAnnotations
implements XmlMetadataAnnotations {
    private static final Pattern COMPACT_PATTERN = Pattern.compile(">\\s+<+");
    public static final String METADATA_ANNOTATIONS_KEY = "metadataAnnotations";
    private StringBuilder xmlContent = new StringBuilder();
    private int lineNumber;
    private int columnNumber;

    @Override
    public void appendElementStart(String qName, Map<String, String> atts) {
        this.xmlContent.append("<" + qName);
        for (Map.Entry<String, String> entry : atts.entrySet()) {
            this.xmlContent.append(" " + entry.getKey() + "=\"" + entry.getValue() + "\"");
        }
        this.xmlContent.append(">");
    }

    @Override
    public void appendElementBody(String elementBody) {
        this.xmlContent.append(elementBody);
    }

    @Override
    public void appendElementEnd(String qName) {
        this.xmlContent.append("</" + qName + ">");
    }

    @Override
    public String getElementString() {
        return COMPACT_PATTERN.matcher(this.xmlContent.toString().trim()).replaceAll(">" + SystemUtils.LINE_SEPARATOR + "<");
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }
}

