/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xml.parser;

import io.qameta.allure.Issue;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.dsl.api.xml.parser.XmlGathererErrorHandler;
import org.mule.runtime.dsl.internal.xml.parser.DefaultXmlGathererErrorHandlerFactory;
import org.mule.runtime.dsl.internal.xml.parser.MuleDocumentLoader;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class MuleDocumentLoaderTestCase {
    private static final String SIMPLE_APPLICATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mule xmlns=\"http://www.mulesoft.org/schema/mule/core\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"\n       http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd\">\n\n    <flow name=\"test\">\n        <logger category=\"SOMETHING\" level=\"WARN\" message=\"logging info\"/>\n    </flow>\n\n</mule>";
    private ClassLoader originalClassLoader;

    @Before
    public void setup() {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @After
    public void tearDown() {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
    }

    @Test
    @Issue(value="MULE-18813")
    public void documentLoaderShouldNotUseThreadCurrentClassLoader() throws Exception {
        MuleDocumentLoader loader = new MuleDocumentLoader();
        URLClassLoader failing = (URLClassLoader)Mockito.mock(URLClassLoader.class);
        Thread.currentThread().setContextClassLoader(failing);
        InputSource is = new InputSource(IOUtils.toInputStream((String)SIMPLE_APPLICATION, (Charset)StandardCharsets.UTF_8));
        XmlGathererErrorHandler errorHandler = new DefaultXmlGathererErrorHandlerFactory().create();
        Document document = loader.loadDocument(SAXParserFactory::newInstance, is, null, (ErrorHandler)errorHandler, 0, false, null);
        Mockito.verifyZeroInteractions((Object[])new Object[]{failing});
        MatcherAssert.assertThat((Object)document, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)errorHandler.getErrors().size(), (Matcher)CoreMatchers.is((Object)0));
    }
}

