/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xml.parser;

import io.qameta.allure.Issue;
import java.io.InputStream;
import java.net.URLClassLoader;
import javax.xml.parsers.SAXParserFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.dsl.api.xml.parser.XmlGathererErrorHandler;
import org.mule.runtime.dsl.internal.xml.parser.DefaultXmlGathererErrorHandlerFactory;
import org.mule.runtime.dsl.internal.xml.parser.MuleDocumentLoader;
import org.mule.runtime.dsl.internal.xml.parser.XmlMetadataAnnotations;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class MuleDocumentLoaderTestCase {
    private ClassLoader originalClassLoader;

    @Before
    public void setup() {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @After
    public void tearDown() {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
    }

    @Test
    @Issue(value="MULE-18813")
    public void documentLoaderShouldNotUseThreadCurrentClassLoader() throws Exception {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("simple_application.xml");
        MuleDocumentLoader loader = new MuleDocumentLoader();
        URLClassLoader failing = (URLClassLoader)Mockito.mock(URLClassLoader.class);
        Thread.currentThread().setContextClassLoader(failing);
        InputSource is = new InputSource(inputStream);
        XmlGathererErrorHandler errorHandler = new DefaultXmlGathererErrorHandlerFactory().create();
        Document document = loader.loadDocument(SAXParserFactory::newInstance, is, null, (ErrorHandler)errorHandler, 0, false, null);
        Mockito.verifyZeroInteractions((Object[])new Object[]{failing});
        MatcherAssert.assertThat((Object)document, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)errorHandler.getErrors(), (Matcher)CoreMatchers.is((Matcher)IsEmptyCollection.empty()));
    }

    @Test
    public void xmlMetadataIsProperlyPopulatedWhenParsingSimpleApplication() throws Exception {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("simple_application.xml");
        MuleDocumentLoader loader = new MuleDocumentLoader();
        InputSource is = new InputSource(inputStream);
        XmlGathererErrorHandler errorHandler = new DefaultXmlGathererErrorHandlerFactory().create();
        Document document = loader.loadDocument(SAXParserFactory::newInstance, is, null, (ErrorHandler)errorHandler, 0, false, null);
        MatcherAssert.assertThat((Object)document, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)errorHandler.getErrors(), (Matcher)CoreMatchers.is((Matcher)IsEmptyCollection.empty()));
        XmlMetadataAnnotations rootAnnotations = (XmlMetadataAnnotations)document.getDocumentElement().getUserData("metadataAnnotations");
        MatcherAssert.assertThat((Object)rootAnnotations, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)rootAnnotations.isSelfClosing(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)rootAnnotations.getOpeningTagBoundaries().getEndLineNumber(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)rootAnnotations.getOpeningTagBoundaries().getEndColumnNumber(), (Matcher)CoreMatchers.is((Object)108));
        MatcherAssert.assertThat((Object)rootAnnotations.getClosingTagBoundaries().getStartLineNumber(), (Matcher)CoreMatchers.is((Object)11));
        MatcherAssert.assertThat((Object)rootAnnotations.getClosingTagBoundaries().getStartColumnNumber(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)rootAnnotations.getClosingTagBoundaries().getEndLineNumber(), (Matcher)CoreMatchers.is((Object)11));
        MatcherAssert.assertThat((Object)rootAnnotations.getClosingTagBoundaries().getEndColumnNumber(), (Matcher)CoreMatchers.is((Object)8));
        XmlMetadataAnnotations flowAnnotations = (XmlMetadataAnnotations)document.getElementsByTagName("flow").item(0).getUserData("metadataAnnotations");
        MatcherAssert.assertThat((Object)flowAnnotations, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)flowAnnotations.isSelfClosing(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)flowAnnotations.getOpeningTagBoundaries().getStartLineNumber(), (Matcher)CoreMatchers.is((Object)7));
        MatcherAssert.assertThat((Object)flowAnnotations.getOpeningTagBoundaries().getStartColumnNumber(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)flowAnnotations.getOpeningTagBoundaries().getEndLineNumber(), (Matcher)CoreMatchers.is((Object)7));
        MatcherAssert.assertThat((Object)flowAnnotations.getOpeningTagBoundaries().getEndColumnNumber(), (Matcher)CoreMatchers.is((Object)23));
        MatcherAssert.assertThat((Object)flowAnnotations.getClosingTagBoundaries().getStartLineNumber(), (Matcher)CoreMatchers.is((Object)9));
        MatcherAssert.assertThat((Object)flowAnnotations.getClosingTagBoundaries().getStartColumnNumber(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)flowAnnotations.getClosingTagBoundaries().getEndLineNumber(), (Matcher)CoreMatchers.is((Object)9));
        MatcherAssert.assertThat((Object)flowAnnotations.getClosingTagBoundaries().getEndColumnNumber(), (Matcher)CoreMatchers.is((Object)12));
        XmlMetadataAnnotations loggerAnnotations = (XmlMetadataAnnotations)document.getElementsByTagName("logger").item(0).getUserData("metadataAnnotations");
        MatcherAssert.assertThat((Object)loggerAnnotations, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)loggerAnnotations.isSelfClosing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)loggerAnnotations.getOpeningTagBoundaries().getStartLineNumber(), (Matcher)CoreMatchers.is((Object)8));
        MatcherAssert.assertThat((Object)loggerAnnotations.getOpeningTagBoundaries().getStartColumnNumber(), (Matcher)CoreMatchers.is((Object)9));
        MatcherAssert.assertThat((Object)loggerAnnotations.getOpeningTagBoundaries().getEndLineNumber(), (Matcher)CoreMatchers.is((Object)8));
        MatcherAssert.assertThat((Object)loggerAnnotations.getOpeningTagBoundaries().getEndColumnNumber(), (Matcher)CoreMatchers.is((Object)75));
        MatcherAssert.assertThat((Object)loggerAnnotations.getClosingTagBoundaries().getStartLineNumber(), (Matcher)CoreMatchers.is((Object)8));
        MatcherAssert.assertThat((Object)loggerAnnotations.getClosingTagBoundaries().getStartColumnNumber(), (Matcher)CoreMatchers.is((Object)9));
        MatcherAssert.assertThat((Object)loggerAnnotations.getClosingTagBoundaries().getEndLineNumber(), (Matcher)CoreMatchers.is((Object)8));
        MatcherAssert.assertThat((Object)loggerAnnotations.getClosingTagBoundaries().getEndColumnNumber(), (Matcher)CoreMatchers.is((Object)75));
    }

    @Test
    public void xmlMetadataIsProperlyPopulatedWhenWhitespaceBetweenLineFeed() throws Exception {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("simple_application_with_whitespace_between_linefeed.xml");
        MuleDocumentLoader loader = new MuleDocumentLoader();
        InputSource is = new InputSource(inputStream);
        XmlGathererErrorHandler errorHandler = new DefaultXmlGathererErrorHandlerFactory().create();
        Document document = loader.loadDocument(SAXParserFactory::newInstance, is, null, (ErrorHandler)errorHandler, 0, false, null);
        MatcherAssert.assertThat((Object)document, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)errorHandler.getErrors(), (Matcher)CoreMatchers.is((Matcher)IsEmptyCollection.empty()));
        XmlMetadataAnnotations rootAnnotations = (XmlMetadataAnnotations)document.getDocumentElement().getUserData("metadataAnnotations");
        MatcherAssert.assertThat((Object)rootAnnotations, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)rootAnnotations.isSelfClosing(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)rootAnnotations.getOpeningTagBoundaries().getEndLineNumber(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)rootAnnotations.getOpeningTagBoundaries().getEndColumnNumber(), (Matcher)CoreMatchers.is((Object)108));
        MatcherAssert.assertThat((Object)rootAnnotations.getClosingTagBoundaries().getStartLineNumber(), (Matcher)CoreMatchers.is((Object)13));
        MatcherAssert.assertThat((Object)rootAnnotations.getClosingTagBoundaries().getStartColumnNumber(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)rootAnnotations.getClosingTagBoundaries().getEndLineNumber(), (Matcher)CoreMatchers.is((Object)13));
        MatcherAssert.assertThat((Object)rootAnnotations.getClosingTagBoundaries().getEndColumnNumber(), (Matcher)CoreMatchers.is((Object)8));
        XmlMetadataAnnotations flowAnnotations = (XmlMetadataAnnotations)document.getElementsByTagName("flow").item(0).getUserData("metadataAnnotations");
        MatcherAssert.assertThat((Object)flowAnnotations, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)flowAnnotations.isSelfClosing(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)flowAnnotations.getOpeningTagBoundaries().getStartLineNumber(), (Matcher)CoreMatchers.is((Object)9));
        MatcherAssert.assertThat((Object)flowAnnotations.getOpeningTagBoundaries().getStartColumnNumber(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)flowAnnotations.getOpeningTagBoundaries().getEndLineNumber(), (Matcher)CoreMatchers.is((Object)9));
        MatcherAssert.assertThat((Object)flowAnnotations.getOpeningTagBoundaries().getEndColumnNumber(), (Matcher)CoreMatchers.is((Object)23));
        MatcherAssert.assertThat((Object)flowAnnotations.getClosingTagBoundaries().getStartLineNumber(), (Matcher)CoreMatchers.is((Object)11));
        MatcherAssert.assertThat((Object)flowAnnotations.getClosingTagBoundaries().getStartColumnNumber(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)flowAnnotations.getClosingTagBoundaries().getEndLineNumber(), (Matcher)CoreMatchers.is((Object)11));
        MatcherAssert.assertThat((Object)flowAnnotations.getClosingTagBoundaries().getEndColumnNumber(), (Matcher)CoreMatchers.is((Object)12));
        XmlMetadataAnnotations loggerAnnotations = (XmlMetadataAnnotations)document.getElementsByTagName("logger").item(0).getUserData("metadataAnnotations");
        MatcherAssert.assertThat((Object)loggerAnnotations, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)loggerAnnotations.isSelfClosing(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)loggerAnnotations.getOpeningTagBoundaries().getStartLineNumber(), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)loggerAnnotations.getOpeningTagBoundaries().getStartColumnNumber(), (Matcher)CoreMatchers.is((Object)9));
        MatcherAssert.assertThat((Object)loggerAnnotations.getOpeningTagBoundaries().getEndLineNumber(), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)loggerAnnotations.getOpeningTagBoundaries().getEndColumnNumber(), (Matcher)CoreMatchers.is((Object)75));
        MatcherAssert.assertThat((Object)loggerAnnotations.getClosingTagBoundaries().getStartLineNumber(), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)loggerAnnotations.getClosingTagBoundaries().getStartColumnNumber(), (Matcher)CoreMatchers.is((Object)9));
        MatcherAssert.assertThat((Object)loggerAnnotations.getClosingTagBoundaries().getEndLineNumber(), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)loggerAnnotations.getClosingTagBoundaries().getEndColumnNumber(), (Matcher)CoreMatchers.is((Object)75));
    }
}

