/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xerces.xni.parser;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.apache.xerces.xni.parser.XMLInputSource;
import org.mule.runtime.dsl.internal.xerces.xni.parser.DefaultXmlSchemaProvider;

@Feature(value="Mule DSL Parsing")
@Story(value="XML Grammar Pool")
public class DefaultXmlSchemaProviderTestCase {
    private DefaultXmlSchemaProvider schemaProvider;

    @Before
    public void setup() {
        this.schemaProvider = new DefaultXmlSchemaProvider();
    }

    @Test
    public void retrieveDefaultXmlSchemas() {
        List schemas = this.schemaProvider.getSchemas();
        MatcherAssert.assertThat((Object)schemas, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)schemas.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        List fakesSchemas = schemas.stream().filter(is -> is.getSystemId().contains("fake-")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)fakesSchemas.size(), (Matcher)CoreMatchers.is((Object)3));
        for (XMLInputSource is2 : schemas) {
            MatcherAssert.assertThat((Object)is2, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)is2.getPublicId(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)is2.getSystemId(), (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)is2.getBaseSystemId(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)is2.getByteStream(), (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        }
    }
}

