/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.dsl.api.component.CommonTypeConverters;

public class CommonTypeConvertersTestCase {
    @Test
    public void stringToEnumDifferentTypes() {
        Assert.assertThat((Object)((Enum)CommonTypeConverters.stringToEnumConverter(TimeUnit.class).convert((Object)"SECONDS")), (Matcher)Is.is((Object)((Object)TimeUnit.SECONDS)));
        Assert.assertThat((Object)((Enum)CommonTypeConverters.stringToEnumConverter(TestEnum.class).convert((Object)"ENUM2")), (Matcher)Is.is((Object)((Object)TestEnum.ENUM2)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullEnumClassConverter() {
        CommonTypeConverters.stringToEnumConverter(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullToEnum() {
        CommonTypeConverters.stringToEnumConverter(TestEnum.class).convert(null);
    }

    private static enum TestEnum {
        ENUM1,
        ENUM2;

    }
}

