/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component.config;

import io.qameta.allure.Issue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Optional;
import java.util.OptionalInt;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class DefaultLocationPartTestCase {
    private DefaultComponentLocation.DefaultLocationPart locationPart;

    @Before
    public void setup() {
        this.locationPart = new DefaultComponentLocation.DefaultLocationPart("part/path", Optional.empty(), Optional.empty(), OptionalInt.of(13), OptionalInt.of(14));
    }

    @Test
    @Issue(value="W-10790023")
    public void serializedAndDeserializedPartPreservesHashAndEquality() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(this.locationPart);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            Object deserialized = ois.readObject();
            Assert.assertThat((Object)deserialized, (Matcher)Matchers.instanceOf(DefaultComponentLocation.DefaultLocationPart.class));
            Assert.assertThat((Object)deserialized.hashCode(), (Matcher)Matchers.is((Object)this.locationPart.hashCode()));
            Assert.assertThat((Object)deserialized, (Matcher)Matchers.is((Object)this.locationPart));
        }
    }
}

