/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.loader.persistence;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.extension.ic.internal.loader.persistence.CatalogTypeLoader;

public class CatalogLoader {
    private CatalogLoader() {
    }

    public static Map<String, MetadataType> loadCatalog(Map<?, ?> jsonCatalog) {
        HashMap catalog = new HashMap();
        IdentityHashMap processing = new IdentityHashMap();
        jsonCatalog.forEach((key, value) -> CatalogLoader.loadEntry(catalog, processing, jsonCatalog, (String)key));
        return catalog.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TypeBuilder)e.getValue()).build()));
    }

    private static TypeBuilder<? extends MetadataType> loadEntry(Map<String, TypeBuilder<?>> catalog, IdentityHashMap<Object, TypeBuilder<?>> processing, Map<?, ?> jsonCatalog, String key) {
        if (catalog.containsKey(key)) {
            return catalog.get(key);
        }
        CatalogTypeLoader loader = new CatalogTypeLoader(typeRef -> typeRef.startsWith("@ref:") ? Optional.of(CatalogLoader.loadEntry(catalog, processing, jsonCatalog, typeRef.substring("@ref:".length()))) : Optional.empty());
        Map catalogTypeElement = (Map)jsonCatalog.get(key);
        if (catalogTypeElement == null) {
            throw new RuntimeException("Element [" + key + "] not found in catalog");
        }
        TypeBuilder<?> typeBuilder = processing.get(catalogTypeElement);
        if (typeBuilder == null) {
            typeBuilder = loader.load(catalogTypeElement, processing).orElseThrow(() -> new RuntimeException("Error loading element [" + key + "]"));
            catalog.put(key, typeBuilder);
        }
        return typeBuilder;
    }
}

