/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.parser;

import com.mulesoft.connectivity.mule.persistence.model.MuleValueProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderReferences;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.loader.parser.ValueProviderModelParser;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityValueProviderParser;
import org.mule.runtime.extension.ic.internal.parser.ParameterModelParserWithDefaults;
import org.mule.runtime.extension.ic.internal.parser.utils.AnnotationUtils;

public class ConnectivityParameterModelParser
implements ParameterModelParserWithDefaults {
    private final ObjectFieldType objectFieldType;
    private final Set<TypeAnnotation> annotations;
    private final MuleValueProviderSerializableModel muleValueProviderSerializableModel;
    private final SerializedProviderReferences providerReferences;
    private static final Set<String> ADVANCED_TAB_PARAMETERS = Set.of("customHeaders", "customQueryParams");

    public ConnectivityParameterModelParser(ObjectFieldType param, MuleValueProviderSerializableModel valueProviderSerializableModel, SerializedProviderReferences providerRefs) {
        this.providerReferences = providerRefs;
        this.objectFieldType = param;
        this.annotations = this.objectFieldType.getValue().getAnnotations();
        this.muleValueProviderSerializableModel = valueProviderSerializableModel;
    }

    public String getName() {
        return this.objectFieldType.getKey().getName().getLocalPart();
    }

    public String getDescription() {
        return AnnotationUtils.findAnnotation(this.annotations, DescriptionAnnotation.class).map(DescriptionAnnotation::getValue).orElse("");
    }

    public MetadataType getType() {
        return this.objectFieldType.getValue();
    }

    public boolean isRequired() {
        return this.objectFieldType.isRequired();
    }

    @Override
    public Object getDefaultValue() {
        return AnnotationUtils.findAnnotation(this.annotations, DefaultValueAnnotation.class).map(DefaultValueAnnotation::getValue).orElse(null);
    }

    public ParameterRole getRole() {
        if (this.objectFieldType.getValue() instanceof ObjectType) {
            return ParameterRole.CONTENT;
        }
        return ParameterRole.BEHAVIOUR;
    }

    public ExpressionSupport getExpressionSupport() {
        return ExpressionSupport.SUPPORTED;
    }

    @Override
    public Optional<LayoutModel> getLayoutModel() {
        if (ADVANCED_TAB_PARAMETERS.contains(this.objectFieldType.getKey().getName().getLocalPart())) {
            return Optional.of(LayoutModel.builder().tabName("Advanced").build());
        }
        return Optional.empty();
    }

    @Override
    public Optional<ValueProviderModelParser> getValueProviderModelParser() {
        if (this.muleValueProviderSerializableModel == null) {
            return Optional.empty();
        }
        List serializedArguments = this.providerReferences.getValueProviderReference() != null ? this.providerReferences.getValueProviderReference().getArguments() : List.of();
        return Optional.of(new ConnectivityValueProviderParser(this.muleValueProviderSerializableModel, serializedArguments));
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        String displayName = AnnotationUtils.findAnnotation(this.annotations, LabelAnnotation.class).map(LabelAnnotation::getValue).orElse(this.objectFieldType.getKey().getName().getLocalPart());
        String description = AnnotationUtils.findAnnotation(this.annotations, DescriptionAnnotation.class).map(DescriptionAnnotation::getValue).orElse("");
        return Optional.of(DisplayModel.builder().displayName(displayName).summary(description).build());
    }

    @Override
    public Set<String> getSemanticTerms() {
        return AnnotationUtils.getSemanticTerms(this.annotations);
    }
}

