/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.runtime.operation;

import com.mulesoft.connectivity.mule.api.operation.OperationResult;
import com.mulesoft.connectivity.mule.api.operation.ResultError;
import com.mulesoft.connectivity.mule.persistence.model.MuleOperationSerializableModel;
import java.util.Map;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.ic.internal.error.ConnectivityException;
import org.mule.runtime.extension.ic.internal.error.DynamicErrorTypeDefinition;
import org.mule.runtime.extension.ic.internal.error.ErrorTypeDefinitionFactory;
import org.mule.runtime.extension.ic.internal.error.ExceptionUtils;
import org.mule.runtime.extension.ic.internal.runtime.connection.Connection;
import org.mule.runtime.extension.ic.internal.runtime.operation.pagination.ConnectivityPagingProvider;

public class OperationExecutor
implements CompletableComponentExecutor<OperationModel> {
    private static final String ATTRIBUTES_FIELD = "attributes";
    private static final String RAW_BODY_FIELD = "rawBody";
    private static final String CONTENT_TYPE = "contentType";
    private final MuleOperationSerializableModel model;

    public OperationExecutor(MuleOperationSerializableModel model) {
        this.model = model;
    }

    public void execute(ExecutionContext<OperationModel> executionContext, CompletableComponentExecutor.ExecutorCallback executorCallback) {
        try {
            ConnectionProvider provider = (ConnectionProvider)executionContext.getConfiguration().flatMap(ConfigurationInstance::getConnectionProvider).orElseThrow();
            Connection connection = (Connection)provider.connect();
            if (this.model.isPaginated()) {
                executorCallback.complete((Object)new ConnectivityPagingProvider(executionContext, this.model));
            } else {
                OperationResult<?> result = connection.executeOperation(this.model, executionContext.getParameters());
                if (result.isSuccess()) {
                    Map successMap = (Map)result.getValue();
                    executorCallback.complete(OperationExecutor.buildResult(successMap));
                } else if (connection.isTokenExpired(result)) {
                    executorCallback.error((Throwable)new AccessTokenExpiredException());
                } else {
                    this.handleOperationFailure(result, executorCallback);
                }
            }
        }
        catch (Exception e) {
            executorCallback.error((Throwable)e);
        }
    }

    private static Result<Object, Object> buildResult(Map<String, Object> resultMap) {
        MediaType mediaType;
        Result.Builder builder = Result.builder();
        String contentType = resultMap.getOrDefault(CONTENT_TYPE, "").toString();
        MediaType mediaType2 = mediaType = contentType != null && !contentType.isBlank() ? MediaType.parse((String)contentType) : MediaType.APPLICATION_JSON;
        if (resultMap.get(RAW_BODY_FIELD) != null) {
            builder.output(resultMap.get(RAW_BODY_FIELD));
            builder.mediaType(mediaType);
        } else {
            builder.output((Object)"");
            builder.mediaType(MediaType.ANY);
        }
        builder.attributes(resultMap.get(ATTRIBUTES_FIELD));
        builder.attributesMediaType(MediaType.APPLICATION_JAVA);
        return builder.build();
    }

    private void handleOperationFailure(OperationResult<?> result, CompletableComponentExecutor.ExecutorCallback executorCallback) {
        ResultError errorValue = result.getErrorValue();
        String kind = errorValue.getKind();
        ErrorTypeDefinition<?> errorTypeDefinition = ErrorTypeDefinitionFactory.createErrorTypeDefinition(kind);
        String errorMessage = this.buildErrorMessage(errorValue, errorTypeDefinition);
        Map errorResultMap = (Map)result.getErrorValue().getValue();
        Result<Object, Object> errorResult = OperationExecutor.buildResult(errorResultMap);
        if (errorTypeDefinition.getType().equals("ANY")) {
            executorCallback.error((Throwable)ExceptionUtils.throwTypedException(errorMessage));
        } else {
            executorCallback.error((Throwable)((Object)new ConnectivityException(errorTypeDefinition, errorMessage, errorResult)));
        }
    }

    private String buildErrorMessage(ResultError error, ErrorTypeDefinition<?> errorTypeDefinition) {
        String fallbackMessage = errorTypeDefinition instanceof DynamicErrorTypeDefinition ? ((DynamicErrorTypeDefinition)errorTypeDefinition).getErrorTypeName() : errorTypeDefinition.toString();
        String errorMessage = error.getDescription().filter(desc -> !desc.trim().isEmpty()).orElse(fallbackMessage);
        return "Error occurred:  " + errorMessage;
    }
}

