/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.error;

import com.mulesoft.connectivity.mule.persistence.model.MuleErrorSerializableModel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.ic.internal.error.ConnectivityError;
import org.mule.runtime.extension.ic.internal.error.ErrorMapper;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityErrorModelParser;
import org.mule.runtime.extension.ic.internal.utils.StringUtils;

public class ConnectivityErrorModelParserFactory {
    private static final boolean IS_NOT_MULE_ERROR = false;
    private static final boolean IS_NOT_SUPPRESSED = false;

    private ConnectivityErrorModelParserFactory() {
    }

    public static List<ConnectivityErrorModelParser> createErrorModelParsers(List<MuleErrorSerializableModel> errorModels, String extensionNamespace) {
        if (errorModels == null || errorModels.isEmpty()) {
            return List.of();
        }
        ArrayList<ConnectivityErrorModelParser> errorModelParsers = new ArrayList<ConnectivityErrorModelParser>();
        LinkedHashSet<String> seenErrorTypes = new LinkedHashSet<String>();
        errorModelParsers.addAll(ConnectivityErrorModelParserFactory.getAllPreDefinedErrorModelParser(extensionNamespace));
        for (MuleErrorSerializableModel errorModel : errorModels) {
            String errorKind = errorModel.getKind();
            ConnectivityErrorModelParser errorParser = ConnectivityErrorModelParserFactory.createErrorModelParser(errorKind, extensionNamespace);
            if (errorParser == null || !seenErrorTypes.add(errorParser.getType())) continue;
            errorModelParsers.add(errorParser);
        }
        return errorModelParsers;
    }

    public static ConnectivityErrorModelParser createErrorModelParser(String errorKind, String extensionNamespace) {
        if (StringUtils.isNullOrEmpty(errorKind)) {
            return null;
        }
        if (ErrorMapper.isStatusCode(errorKind)) {
            String statusName = ErrorMapper.getHttpStatusName(errorKind);
            if (statusName == null) {
                return ConnectivityErrorModelParserFactory.getDefaultErrorModelParser(errorKind, extensionNamespace);
            }
            return ConnectivityErrorModelParserFactory.createErrorModelParserFromResolvedName(statusName, errorKind, extensionNamespace);
        }
        return ConnectivityErrorModelParserFactory.createErrorModelParserFromResolvedName(errorKind, null, extensionNamespace);
    }

    private static ConnectivityErrorModelParser createErrorModelParserFromResolvedName(String errorTypeName, String errorKind, String extensionNamespace) {
        ConnectivityError connectivityError = ConnectivityError.fromString(errorTypeName);
        if (connectivityError == null) {
            ConnectivityErrorModelParser parentParser = ConnectivityErrorModelParserFactory.getDefaultErrorModelParser(errorKind, extensionNamespace);
            return ConnectivityErrorModelParserFactory.createErrorModelParser(errorTypeName, extensionNamespace, false, parentParser);
        }
        return ConnectivityErrorModelParserFactory.createErrorModelParserChain(connectivityError, extensionNamespace);
    }

    public static ConnectivityErrorModelParser getDefaultErrorModelParser(String statusCode, String extensionNamespace) {
        ErrorTypeDefinition<?> errorType = ErrorMapper.isStatusCode(statusCode) ? ErrorMapper.mapStatusCodeToErrorType(ErrorMapper.getStatusCode(statusCode)) : MuleErrors.ANY;
        return ConnectivityErrorModelParserFactory.createErrorModelParserChain(errorType, extensionNamespace);
    }

    private static List<ConnectivityErrorModelParser> getAllPreDefinedErrorModelParser(String extensionNamespace) {
        ArrayList<ConnectivityErrorModelParser> errorModelParsers = new ArrayList<ConnectivityErrorModelParser>();
        for (ErrorTypeDefinition<ConnectivityError> errorTypeDefinition : ConnectivityError.getErrorTypeList()) {
            errorModelParsers.add(ConnectivityErrorModelParserFactory.createErrorModelParserChain(errorTypeDefinition, extensionNamespace));
        }
        return errorModelParsers;
    }

    private static ConnectivityErrorModelParser createErrorModelParser(String errorType, String namespace, boolean isMuleError, ConnectivityErrorModelParser parent) {
        return new ConnectivityErrorModelParser(errorType, namespace, isMuleError, false, parent);
    }

    private static ConnectivityErrorModelParser createErrorModelParserChain(ErrorTypeDefinition<?> errorTypeDefinition, String extensionNameSpace) {
        boolean isMuleError;
        Optional parentErrorTypeDefinition = errorTypeDefinition.getParent();
        ConnectivityErrorModelParser parentParser = null;
        if (parentErrorTypeDefinition.isPresent()) {
            ErrorTypeDefinition parentConnectivityErrorDef = (ErrorTypeDefinition)parentErrorTypeDefinition.get();
            parentParser = ConnectivityErrorModelParserFactory.createErrorModelParserChain(parentConnectivityErrorDef, extensionNameSpace);
        }
        extensionNameSpace = (isMuleError = errorTypeDefinition instanceof MuleErrors) ? "MULE" : extensionNameSpace;
        return ConnectivityErrorModelParserFactory.createErrorModelParser(errorTypeDefinition.getType(), extensionNameSpace, isMuleError, parentParser);
    }
}

