/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.runtime.operation;

import com.mulesoft.connectivity.mule.api.Content;
import com.mulesoft.connectivity.mule.api.operation.OperationResult;
import com.mulesoft.connectivity.mule.api.operation.ResultError;
import com.mulesoft.connectivity.mule.persistence.model.MuleOperationSerializableModel;
import java.util.Set;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.ic.internal.error.ConnectivityError;
import org.mule.runtime.extension.ic.internal.error.ConnectivityException;
import org.mule.runtime.extension.ic.internal.error.ErrorTypeDefinitionFactory;
import org.mule.runtime.extension.ic.internal.runtime.connection.Connection;
import org.mule.runtime.extension.ic.internal.runtime.operation.pagination.ConnectivityPagingProvider;
import org.mule.runtime.extension.ic.internal.utils.ContentExtractorUtils;

public class OperationExecutor
implements CompletableComponentExecutor<OperationModel> {
    private final MuleOperationSerializableModel model;

    public OperationExecutor(MuleOperationSerializableModel model) {
        this.model = model;
    }

    public void execute(ExecutionContext<OperationModel> executionContext, CompletableComponentExecutor.ExecutorCallback executorCallback) {
        try {
            ConnectionProvider provider = (ConnectionProvider)executionContext.getConfiguration().flatMap(ConfigurationInstance::getConnectionProvider).orElseThrow();
            Connection connection = (Connection)provider.connect();
            if (this.model.isPaginated()) {
                executorCallback.complete((Object)new ConnectivityPagingProvider(executionContext, this.model));
            } else {
                OperationResult<?> result = connection.executeOperation(this.model, executionContext.getParameters());
                if (result.isSuccess()) {
                    Content content = (Content)result.getValue();
                    executorCallback.complete(OperationExecutor.buildResult(content));
                } else if (connection.isTokenExpired(result)) {
                    executorCallback.error((Throwable)new AccessTokenExpiredException());
                } else {
                    this.handleOperationFailure(executionContext.getExtensionModel().getName(), result, ((OperationModel)executionContext.getComponentModel()).getErrorModels(), executorCallback);
                }
            }
        }
        catch (Exception e) {
            executorCallback.error((Throwable)new ModuleException(e.getMessage(), (ErrorTypeDefinition)ConnectivityError.CONNECTIVITY, (Throwable)e));
        }
    }

    private static Result<Object, Object> buildResult(Content content) {
        Result.Builder builder = Result.builder();
        MediaType mediaType = ContentExtractorUtils.getMediaType(content);
        builder.output((Object)"");
        builder.mediaType(MediaType.ANY);
        content.getRawValue().ifPresent(rawVal -> {
            builder.output(rawVal);
            builder.mediaType(mediaType);
        });
        builder.attributes(ContentExtractorUtils.getOutputAttributes(content));
        builder.attributesMediaType(MediaType.APPLICATION_JAVA);
        return builder.build();
    }

    private void handleOperationFailure(String extensionName, OperationResult<?> result, Set<ErrorModel> errorModels, CompletableComponentExecutor.ExecutorCallback executorCallback) {
        ResultError errorValue = result.getErrorValue();
        String kind = errorValue.getKind();
        ErrorTypeDefinition<?> errorTypeDefinition = ErrorTypeDefinitionFactory.createErrorTypeDefinition(extensionName, kind, errorModels);
        String errorMessage = this.buildErrorMessage(errorValue, errorTypeDefinition);
        Result errorResult = errorValue.getContent().map(OperationExecutor::buildResult).orElse(Result.builder().build());
        executorCallback.error((Throwable)((Object)new ConnectivityException(errorTypeDefinition, errorMessage, (Result<Object, Object>)errorResult)));
    }

    private String buildErrorMessage(ResultError error, ErrorTypeDefinition<?> errorTypeDefinition) {
        String fallbackMessage = errorTypeDefinition.getType();
        String errorMessage = error.getDescription().filter(desc -> !desc.trim().isEmpty()).orElse(fallbackMessage);
        return "Error occurred:  " + errorMessage;
    }
}

