/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.loader;

import static org.mule.runtime.extension.ic.internal.loader.ExtensionConstants.CONNECTIVITY_EXTENSION_MODEL_ID;

import org.mule.runtime.extension.api.loader.AbstractParserBasedExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.parser.ExtensionModelParserFactory;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityExtensionModelParserFactory;

import java.util.List;

public class ConnectivityExtensionModelLoader extends AbstractParserBasedExtensionModelLoader {

  @Override
  protected ExtensionModelParserFactory getExtensionModelParserFactory(ExtensionLoadingContext context) {
    return new ConnectivityExtensionModelParserFactory();
  }

  @Override
  public String getId() {
    return CONNECTIVITY_EXTENSION_MODEL_ID;
  }

  @Override
  protected void configureContextBeforeDeclaration(ExtensionLoadingContext context) {
    context.addCustomValidators(List.of());
  }
}
