/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.parser;

import static org.mule.runtime.extension.ic.internal.loader.ExtensionConstants.MODULE_PATH;

import static java.lang.String.format;

import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.parser.ExtensionModelParser;
import org.mule.runtime.extension.api.loader.parser.ExtensionModelParserFactory;
import org.mule.runtime.extension.ic.internal.loader.ConnectorLoaderHandler;

import com.mulesoft.connectivity.mule.persistence.deserialize.loader.MuleModelDeserializer;
import com.mulesoft.connectivity.mule.persistence.model.MuleConnectorSerializableModel;

/**
 * Factory for creating connectivity extension model parsers. Instantiates the appropriate parser based on the extension loading
 * context.
 */
public class ConnectivityExtensionModelParserFactory implements ExtensionModelParserFactory {

  @Override
  public ExtensionModelParser createParser(ExtensionLoadingContext context) {
    final String modulePath = context.<String>getParameter(MODULE_PATH)
        .orElseThrow(() -> new IllegalArgumentException(format("The attribute '%s' is missing", MODULE_PATH)));

    return new ConnectivityExtensionModelParser(loadConnectorModel(modulePath));
  }

  private MuleConnectorSerializableModel loadConnectorModel(String modulePath) {
    try {
      return ConnectorLoaderHandler.loadConnectorModel(new MuleModelDeserializer(), modulePath);
    } catch (Exception e) {
      throw new RuntimeException("Error occurred when describing the model: " + modulePath, e);
    }
  }
}
