/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.parser.utils;

import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.extension.api.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityParameterGroupParser;

import com.mulesoft.connectivity.mule.persistence.model.MuleConnectorSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedObjectFieldSelector;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderReferences;

import java.util.List;
import java.util.Map;

public class ModelParserUtils {

  private ModelParserUtils() {}

  public static List<ParameterGroupModelParser> getParameterGroupParser(MuleConnectorSerializableModel muleConnectorSerializableModel,
                                                                        MetadataType metadataType,
                                                                        Map<SerializedObjectFieldSelector, SerializedProviderReferences> inputResolvedProviders,
                                                                        String parameterGroupName,
                                                                        boolean isConnectionProvider, List<String> paramsToOmit) {
    return List.of(new ConnectivityParameterGroupParser(muleConnectorSerializableModel, metadataType, inputResolvedProviders,
                                                        parameterGroupName, isConnectionProvider, paramsToOmit));
  }
}
