/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.error;

import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;

import java.util.List;
import java.util.Optional;

/**
 * Enum representing connectivity error types.
 */
public enum ConnectivityError implements ErrorTypeDefinition<ConnectivityError> {

  // Define base error types
  CONNECTIVITY(MuleErrors.CONNECTIVITY), SECURITY(MuleErrors.SECURITY), CLIENT_ERROR(MuleErrors.ANY), SERVER_ERROR(
      MuleErrors.ANY), UNAUTHORIZED(
          SECURITY), FORBIDDEN(SECURITY), TIMEOUT(CLIENT_ERROR);

  private static final List<ErrorTypeDefinition<ConnectivityError>> ERROR_TYPE_LIST;
  private ErrorTypeDefinition<?> parentErrorType;

  static {
    ERROR_TYPE_LIST = List.of(CONNECTIVITY, SECURITY, CLIENT_ERROR, SERVER_ERROR, UNAUTHORIZED, FORBIDDEN, TIMEOUT);
  }

  ConnectivityError() {}

  ConnectivityError(ErrorTypeDefinition<?> parentErrorType) {
    this.parentErrorType = parentErrorType;
  }

  public static List<ErrorTypeDefinition<ConnectivityError>> getErrorTypeList() {
    return ERROR_TYPE_LIST;
  }

  public static ConnectivityError fromString(String errorType) {
    for (ConnectivityError error : ConnectivityError.values()) {
      if (error.name().equals(errorType)) {
        return error;
      }
    }
    return null;
  }

  @Override
  public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
    return Optional.ofNullable(parentErrorType);
  }
}
