/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.parser;

import static org.mule.runtime.api.meta.model.parameter.ParameterGroupModel.DEFAULT_GROUP_NAME;
import static org.mule.runtime.extension.ic.internal.parser.utils.ModelParserUtils.getParameterGroupParser;

import org.mule.runtime.api.meta.model.ComponentVisibility;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.loader.parser.AttributesResolverModelParser;
import org.mule.runtime.extension.api.loader.parser.MediaTypeParser;
import org.mule.runtime.extension.api.loader.parser.MinMuleVersionParser;
import org.mule.runtime.extension.api.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.extension.api.loader.parser.StereotypeModelFactory;
import org.mule.runtime.extension.api.loader.parser.metadata.MetadataKeyModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.OutputResolverModelParser;
import org.mule.runtime.extension.api.runtime.exception.SdkExceptionHandlerFactory;

import com.mulesoft.connectivity.mule.persistence.model.MuleConnectorSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleExecutableComponentSerializableModel;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class ConnectivityExecutableModelParser<T extends MuleExecutableComponentSerializableModel> {

  protected final T model;
  protected final MuleConnectorSerializableModel connectorModel;

  public ConnectivityExecutableModelParser(MuleConnectorSerializableModel connectorModel, T model) {
    this.connectorModel = connectorModel;
    this.model = model;
  }

  public String getName() {
    return model.getName();
  }

  public String getDescription() {
    return model.getDisplayName();
  }

  public List<ParameterGroupModelParser> getParameterGroupModelParsers() {
    return getParameterGroupParser(connectorModel, model.getInputType(), model.getInputResolvedProviders(), DEFAULT_GROUP_NAME,
                                   false, List.of());
  }

  public boolean isIgnored() {
    return false;
  }

  public boolean isConnected() {
    return true;
  }

  public boolean isTransactional() {
    return false;
  }

  public Optional<MediaTypeParser> getMediaType() {
    // NOTE: Eventually we want to specify this as some kind of internal MediaType that says "this is the result of a DW
    // evaluation". Keeping it undefined for now.
    return Optional.empty();
  }

  public Optional<SdkExceptionHandlerFactory> getExceptionHandlerFactory() {
    // FIXME: To be either filled or decided to always be empty by W-18944117
    return Optional.empty();
  }

  public Optional<DeprecationModel> getDeprecationModel() {
    // NOTE: Current versioning strategies for LW do not allow deprecation or removal of any connector element.
    return Optional.empty();
  }

  public Optional<MinMuleVersionParser> getResolvedMinMuleVersion() {
    return Optional.empty();
  }

  public Optional<OutputResolverModelParser> getOutputResolverModelParser() {
    // FIXME: To be resolved by W-18354029 (output type)
    return Optional.empty();
  }

  public Optional<AttributesResolverModelParser> getAttributesResolverModelParser() {
    // FIXME: To be resolved by W-18354029 (output attributes)
    return Optional.empty();
  }

  public Optional<MetadataKeyModelParser> getMetadataKeyModelParser() {
    // FIXME: To be resolved by W-18354029 (metadata key)
    return Optional.empty();
  }

  public List<ModelProperty> getAdditionalModelProperties() {
    return List.of();
  }

  public boolean hasConfig() {
    return true;
  }

  public ComponentVisibility getComponentVisibility() {
    return ComponentVisibility.PUBLIC;
  }

  public Stream<NotificationModel> getEmittedNotificationsStream(Function<String, Optional<NotificationModel>> notificationMapper) {
    return Stream.empty();
  }

  public Optional<StereotypeModel> getStereotype(StereotypeModelFactory factory) {
    return Optional.empty();
  }
}
