/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.parser;

import org.mule.runtime.extension.api.loader.parser.LicenseModelParser;

import java.util.Optional;

public class ConnectivityLicenseModelParser implements LicenseModelParser {

  private final boolean requiresEeLicense;
  private final boolean allowsEvaluationLicense;

  public ConnectivityLicenseModelParser(boolean requiresEeLicense, boolean allowsEvaluationLicense) {
    this.requiresEeLicense = requiresEeLicense;
    this.allowsEvaluationLicense = allowsEvaluationLicense;
  }

  @Override
  public boolean requiresEeLicense() {
    return this.requiresEeLicense;
  }

  @Override
  public boolean isAllowsEvaluationLicense() {
    return this.allowsEvaluationLicense;
  }

  @Override
  public Optional<String> getRequiredEntitlement() {
    return Optional.empty();
  }
}
