/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.parser;

import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.extension.api.loader.parser.OutputModelParser;

public class ConnectivityOutputModelParser implements OutputModelParser {

  private final MetadataType metadataType;
  private final boolean isDynamic;

  public ConnectivityOutputModelParser(MetadataType metadataType, boolean isDynamic) {
    this.metadataType = metadataType;
    this.isDynamic = isDynamic;
  }

  @Override
  public MetadataType getType() {
    return this.metadataType;
  }

  @Override
  public boolean isDynamic() {
    return this.isDynamic;
  }
}
