/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.parser;

import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.extension.api.loader.parser.ActingParameterModelParser;
import org.mule.runtime.extension.api.loader.parser.ValueProviderFactory;
import org.mule.runtime.extension.api.loader.parser.ValueProviderModelParser;
import org.mule.runtime.extension.ic.internal.runtime.valueProvider.ValueProviderExecutorFactory;

import com.mulesoft.connectivity.mule.persistence.model.MuleValueProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderArgument;

import java.util.List;
import java.util.Optional;

public class ConnectivityValueProviderParser implements ValueProviderModelParser {

  private final MuleValueProviderSerializableModel muleValueProviderSerializableModel;
  private final List<SerializedProviderArgument> providerArguments;

  public ConnectivityValueProviderParser(MuleValueProviderSerializableModel muleValueProviderSerializableModel,
                                         List<SerializedProviderArgument> providerArguments) {
    this.muleValueProviderSerializableModel = muleValueProviderSerializableModel;
    this.providerArguments = providerArguments;
  }

  @Override
  public String getId() {
    return muleValueProviderSerializableModel.getName();
  }

  @Override
  public boolean isOpen() {
    /*
     * A boolean indicating if the calculated values should be considered as an open or closed Not supported by IC to toggle any
     * flag like this
     */
    return true;
  }

  @Override
  public List<ActingParameterModelParser> getActingParameterParsers() {
    // acting parameters are not handled by runtime (ValueProviderFactoryWrapper), so we return an empty list here
    return List.of();
  }

  @Override
  public boolean requiresConfiguration() {
    return true;
  }

  @Override
  public boolean requiresConnection() {
    return true;
  }

  @Override
  public Optional<Integer> getPartOrder() {
    return Optional.empty();
  }

  @Override
  public ValueProviderFactory getValueProviderFactory() {
    return new ValueProviderExecutorFactory(muleValueProviderSerializableModel, providerArguments);
  }

  @Override
  public List<ModelProperty> getAdditionalModelProperties() {
    return List.of();
  }
}
