/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.parser;

import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.extension.api.loader.parser.ParameterGroupModelParser;

import java.util.List;
import java.util.Optional;

/**
 * Common configurations for parameter groups. Removes duplicated code and appeases the SonarQube report.
 */
public interface ParameterGroupModelParserWithDefaults extends ParameterGroupModelParser {

  @Override
  default Optional<DisplayModel> getDisplayModel() {
    return Optional.empty();
  }

  @Override
  default Optional<LayoutModel> getLayoutModel() {
    return Optional.empty();
  }

  @Override
  default Optional<ExclusiveOptionalDescriptor> getExclusiveOptionals() {
    return Optional.empty();
  }

  @Override
  default boolean showsInDsl() {
    // Returns false to use flat parameter structure in DSL for simpler configuration
    // IC extensions avoid nested parameter groups to maintain consistency with standard connectors
    return false;
  }

  @Override
  default List<ModelProperty> getAdditionalModelProperties() {
    return List.of();
  }
}
